/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timer.schedule;

import java.util.HashSet;
import java.util.Set;
import org.jboss.ejb3.timer.schedule.IncrementValue;
import org.jboss.ejb3.timer.schedule.ListValue;
import org.jboss.ejb3.timer.schedule.RangeValue;
import org.jboss.ejb3.timer.schedule.ScheduleExpressionType;
import org.jboss.ejb3.timer.schedule.ScheduleExpressionTypeUtil;
import org.jboss.ejb3.timer.schedule.SingleValue;

public abstract class IntegerBasedExpression {
    protected abstract Integer getMaxValue();

    protected abstract Integer getMinValue();

    protected Set<Integer> processListValue(ListValue list) {
        HashSet<Integer> values = new HashSet<Integer>();
        Set<String> listItems = list.getValues();
        for (String listItem : listItems) {
            values.addAll(this.processListItem(listItem));
        }
        return values;
    }

    protected Set<Integer> processListItem(String listItem) {
        ScheduleExpressionType listItemType = ScheduleExpressionTypeUtil.getType(listItem);
        switch (listItemType) {
            case SINGLE_VALUE: {
                Integer value = this.get(listItem);
                HashSet<Integer> values = new HashSet<Integer>();
                values.add(value);
                return values;
            }
            case RANGE: {
                RangeValue range = new RangeValue(listItem);
                return this.processRangeValue(range);
            }
        }
        throw new IllegalArgumentException("A list value can only contain either a range or an individual value. Invalid value: " + listItem);
    }

    protected Set<Integer> processRangeValue(RangeValue range) {
        HashSet<Integer> values = new HashSet<Integer>();
        String start = range.getStart();
        String end = range.getEnd();
        Integer rangeStart = this.get(start);
        Integer rangeEnd = this.get(end);
        if (rangeStart > this.getMaxValue() || rangeStart < this.getMinValue()) {
            throw new IllegalArgumentException("Invalid value for range start: " + rangeStart + " Valid values are between " + this.getMinValue() + " and " + this.getMaxValue());
        }
        if (rangeEnd > this.getMaxValue() || rangeEnd < this.getMinValue()) {
            throw new IllegalArgumentException("Invalid value for range end: " + rangeEnd + " Valid values are between " + this.getMinValue() + " and " + this.getMaxValue());
        }
        if (rangeStart == rangeEnd) {
            values.add(rangeStart);
        } else if (rangeStart > rangeEnd) {
            int i;
            for (i = rangeStart.intValue(); i <= this.getMaxValue(); ++i) {
                values.add(i);
            }
            for (i = this.getMinValue().intValue(); i <= rangeEnd; ++i) {
                values.add(i);
            }
        } else {
            for (int i = rangeStart.intValue(); i <= rangeEnd; ++i) {
                values.add(i);
            }
        }
        return values;
    }

    protected Set<Integer> processIncrement(IncrementValue incr) {
        String startValue = incr.getStart();
        Integer start = startValue.equals("*") ? 0 : Integer.parseInt(startValue);
        Integer interval = this.get(incr.getInterval());
        HashSet<Integer> values = new HashSet<Integer>();
        values.add(start);
        int maxValue = this.getMaxValue();
        for (int next = start + interval; next <= maxValue; next += interval.intValue()) {
            values.add(next);
        }
        return values;
    }

    protected Integer processSingleValue(SingleValue singleValue) {
        return this.get(singleValue.getValue());
    }

    protected Integer get(String alias) {
        if (alias == null) {
            return null;
        }
        return Integer.parseInt(alias.trim());
    }
}

