/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timer.schedule;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jboss.ejb3.timer.schedule.IntegerBasedExpression;

public abstract class MixedValueTypeExpression
extends IntegerBasedExpression {
    private Map<String, Integer> lowercaseAliases = new HashMap<String, Integer>();

    protected abstract Map<String, Integer> getAliases();

    public MixedValueTypeExpression() {
        Map<String, Integer> tmpAliases = this.getAliases();
        if (tmpAliases != null) {
            for (Map.Entry<String, Integer> entry : tmpAliases.entrySet()) {
                String key = entry.getKey();
                String lowerCaseAlias = key.toLowerCase(Locale.ENGLISH);
                this.lowercaseAliases.put(lowerCaseAlias, entry.getValue());
            }
        }
    }

    @Override
    protected Integer get(String alias) {
        try {
            return super.get(alias);
        }
        catch (NumberFormatException nfe) {
            if (this.lowercaseAliases != null) {
                String lowerCaseAlias = alias.toLowerCase(Locale.ENGLISH);
                return this.lowercaseAliases.get(lowerCaseAlias);
            }
            return null;
        }
    }
}

