/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timer.schedule;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.ejb3.timer.schedule.IncrementValue;
import org.jboss.ejb3.timer.schedule.IntegerBasedExpression;
import org.jboss.ejb3.timer.schedule.ListValue;
import org.jboss.ejb3.timer.schedule.RangeValue;
import org.jboss.ejb3.timer.schedule.ScheduleExpressionType;
import org.jboss.ejb3.timer.schedule.ScheduleExpressionTypeUtil;
import org.jboss.ejb3.timer.schedule.SingleValue;

public class Second
extends IntegerBasedExpression {
    public static final Integer MAX_SECOND = 59;
    public static final Integer MIN_SECOND = 0;
    private SortedSet<Integer> seconds = new TreeSet<Integer>();
    private ScheduleExpressionType expressionType;

    public Second(String value) {
        this.expressionType = ScheduleExpressionTypeUtil.getType(value);
        Set<Integer> secs = null;
        switch (this.expressionType) {
            case RANGE: {
                RangeValue range = new RangeValue(value);
                secs = this.processRangeValue(range);
                this.seconds.addAll(secs);
                break;
            }
            case LIST: {
                ListValue list = new ListValue(value);
                secs = this.processListValue(list);
                this.seconds.addAll(secs);
                break;
            }
            case INCREMENT: {
                IncrementValue incrValue = new IncrementValue(value);
                secs = this.processIncrement(incrValue);
                this.seconds.addAll(secs);
                break;
            }
            case SINGLE_VALUE: {
                SingleValue singleValue = new SingleValue(value);
                Integer sec = this.processSingleValue(singleValue);
                this.seconds.add(sec);
                break;
            }
            case WILDCARD: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for second: " + value);
            }
        }
    }

    public Calendar getNextSecond(Calendar current) {
        GregorianCalendar next = new GregorianCalendar(current.getTimeZone());
        next.setTime(current.getTime());
        Integer currentSecond = current.get(13);
        if (this.expressionType == ScheduleExpressionType.WILDCARD) {
            return current;
        }
        Integer nextSecond = this.seconds.first();
        for (Integer second : this.seconds) {
            if (currentSecond.equals(second)) {
                nextSecond = currentSecond;
                break;
            }
            if (second <= currentSecond) continue;
            nextSecond = second;
            break;
        }
        if (nextSecond < currentSecond) {
            ((Calendar)next).add(12, 1);
        }
        next.set(13, nextSecond);
        return next;
    }

    public int getFirst() {
        if (this.expressionType == ScheduleExpressionType.WILDCARD) {
            return new GregorianCalendar().get(13);
        }
        return this.seconds.first();
    }

    @Override
    protected Integer getMaxValue() {
        return MAX_SECOND;
    }

    @Override
    protected Integer getMinValue() {
        return MIN_SECOND;
    }
}

