/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timer.schedule.attribute;

import java.util.Calendar;
import java.util.SortedSet;
import org.jboss.ejb3.timer.schedule.attribute.IntegerBasedExpression;
import org.jboss.ejb3.timer.schedule.value.ScheduleExpressionType;

public class Minute
extends IntegerBasedExpression {
    public static final Integer MAX_MINUTE = 59;
    public static final Integer MIN_MINUTE = 0;

    public Minute(String value) {
        super(value);
    }

    public int getFirst() {
        if (this.scheduleExpressionType == ScheduleExpressionType.WILDCARD) {
            return 0;
        }
        SortedSet<Integer> eligibleMinutes = this.getEligibleMinutes();
        if (eligibleMinutes.isEmpty()) {
            throw new IllegalStateException("There are no valid minutes for expression: " + this.origValue);
        }
        return eligibleMinutes.first();
    }

    @Override
    protected Integer getMaxValue() {
        return MAX_MINUTE;
    }

    @Override
    protected Integer getMinValue() {
        return MIN_MINUTE;
    }

    @Override
    public boolean isRelativeValue(String value) {
        return false;
    }

    @Override
    protected boolean accepts(ScheduleExpressionType scheduleExprType) {
        switch (scheduleExprType) {
            case RANGE: 
            case LIST: 
            case SINGLE_VALUE: 
            case WILDCARD: 
            case INCREMENT: {
                return true;
            }
        }
        return false;
    }

    private SortedSet<Integer> getEligibleMinutes() {
        return this.absoluteValues;
    }

    public Integer getNextMatch(Calendar currentCal) {
        if (this.scheduleExpressionType == ScheduleExpressionType.WILDCARD) {
            return currentCal.get(12);
        }
        if (this.absoluteValues.isEmpty()) {
            return null;
        }
        int currentMinute = currentCal.get(12);
        for (Integer minute : this.absoluteValues) {
            if (currentMinute == minute) {
                return currentMinute;
            }
            if (minute <= currentMinute) continue;
            return minute;
        }
        return (Integer)this.absoluteValues.first();
    }
}

