/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timer.schedule;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.ejb3.timer.schedule.ListValue;
import org.jboss.ejb3.timer.schedule.MixedValueTypeExpression;
import org.jboss.ejb3.timer.schedule.RangeValue;
import org.jboss.ejb3.timer.schedule.ScheduleExpressionType;
import org.jboss.ejb3.timer.schedule.ScheduleExpressionTypeUtil;
import org.jboss.ejb3.timer.schedule.SingleValue;

public class DayOfWeek
extends MixedValueTypeExpression {
    public static final Integer MAX_DAY_OF_WEEK = 7;
    public static final Integer MIN_DAY_OF_WEEK = 0;
    private static final Map<String, Integer> DAY_OF_WEEK_ALIAS = new HashMap<String, Integer>();
    private static final int OFFSET;
    private SortedSet<Integer> daysOfWeek = new TreeSet<Integer>();
    private SortedSet<Integer> offsetAdjustedDaysOfWeek = new TreeSet<Integer>();
    private ScheduleExpressionType expressionType;

    public DayOfWeek(String value) {
        this.expressionType = ScheduleExpressionTypeUtil.getType(value);
        Set<Integer> days = null;
        switch (this.expressionType) {
            case RANGE: {
                RangeValue range = new RangeValue(value);
                days = this.processRangeValue(range);
                this.daysOfWeek.addAll(days);
                break;
            }
            case LIST: {
                ListValue list = new ListValue(value);
                days = this.processListValue(list);
                this.daysOfWeek.addAll(days);
                break;
            }
            case SINGLE_VALUE: {
                SingleValue singleValue = new SingleValue(value);
                Integer day = this.processSingleValue(singleValue);
                this.daysOfWeek.add(day);
                break;
            }
            case WILDCARD: {
                break;
            }
            case INCREMENT: {
                throw new IllegalArgumentException("Increment type expression is not allowed for day-of-week value. Invalid value: " + value);
            }
        }
        if (OFFSET != 0) {
            for (Integer dayOfWeek : this.daysOfWeek) {
                this.offsetAdjustedDaysOfWeek.add(dayOfWeek - OFFSET);
            }
        } else {
            this.offsetAdjustedDaysOfWeek = this.daysOfWeek;
        }
    }

    @Override
    protected Map<String, Integer> getAliases() {
        return DAY_OF_WEEK_ALIAS;
    }

    @Override
    protected Integer getMaxValue() {
        return MAX_DAY_OF_WEEK;
    }

    @Override
    protected Integer getMinValue() {
        return MIN_DAY_OF_WEEK;
    }

    public Calendar getNextDayOfWeek(Calendar current) {
        if (this.expressionType == ScheduleExpressionType.WILDCARD) {
            return current;
        }
        GregorianCalendar next = new GregorianCalendar(current.getTimeZone());
        next.setTime(current.getTime());
        next.setFirstDayOfWeek(current.getFirstDayOfWeek());
        Integer currentDayOfWeek = current.get(7);
        Integer nextDayOfWeek = this.offsetAdjustedDaysOfWeek.first();
        for (Integer dayOfWeek : this.offsetAdjustedDaysOfWeek) {
            if (currentDayOfWeek.equals(dayOfWeek)) {
                nextDayOfWeek = currentDayOfWeek;
                break;
            }
            if (dayOfWeek <= currentDayOfWeek) continue;
            nextDayOfWeek = dayOfWeek;
            break;
        }
        if (nextDayOfWeek < currentDayOfWeek) {
            ((Calendar)next).add(4, 1);
        }
        int maximumPossibleDateForTheMonth = ((Calendar)next).getActualMaximum(5);
        int date = next.get(5);
        while (date > maximumPossibleDateForTheMonth) {
            ((Calendar)next).add(2, 1);
            maximumPossibleDateForTheMonth = ((Calendar)next).getActualMaximum(5);
        }
        next.set(7, nextDayOfWeek);
        return next;
    }

    public int getFirst() {
        if (this.expressionType == ScheduleExpressionType.WILDCARD) {
            return new GregorianCalendar().get(7);
        }
        return this.offsetAdjustedDaysOfWeek.first();
    }

    static {
        DAY_OF_WEEK_ALIAS.put("Sun", 0);
        DAY_OF_WEEK_ALIAS.put("Mon", 1);
        DAY_OF_WEEK_ALIAS.put("Tue", 2);
        DAY_OF_WEEK_ALIAS.put("Wed", 3);
        DAY_OF_WEEK_ALIAS.put("Thu", 4);
        DAY_OF_WEEK_ALIAS.put("Fri", 5);
        DAY_OF_WEEK_ALIAS.put("Sat", 6);
        OFFSET = DAY_OF_WEEK_ALIAS.get("Sun") - 1;
    }
}

