/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timer.schedule;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.ejb3.timer.schedule.IncrementValue;
import org.jboss.ejb3.timer.schedule.IntegerBasedExpression;
import org.jboss.ejb3.timer.schedule.ListValue;
import org.jboss.ejb3.timer.schedule.RangeValue;
import org.jboss.ejb3.timer.schedule.ScheduleExpressionType;
import org.jboss.ejb3.timer.schedule.ScheduleExpressionTypeUtil;
import org.jboss.ejb3.timer.schedule.SingleValue;

public class Minute
extends IntegerBasedExpression {
    public static final Integer MAX_MINUTE = 59;
    public static final Integer MIN_MINUTE = 0;
    private SortedSet<Integer> minutes = new TreeSet<Integer>();
    private ScheduleExpressionType expressionType;

    public Minute(String value) {
        this.expressionType = ScheduleExpressionTypeUtil.getType(value);
        Set<Integer> mins = null;
        switch (this.expressionType) {
            case RANGE: {
                RangeValue range = new RangeValue(value);
                mins = this.processRangeValue(range);
                this.minutes.addAll(mins);
                break;
            }
            case LIST: {
                ListValue list = new ListValue(value);
                mins = this.processListValue(list);
                this.minutes.addAll(mins);
                break;
            }
            case INCREMENT: {
                IncrementValue incrValue = new IncrementValue(value);
                mins = this.processIncrement(incrValue);
                this.minutes.addAll(mins);
                break;
            }
            case SINGLE_VALUE: {
                SingleValue singleValue = new SingleValue(value);
                Integer minute = this.processSingleValue(singleValue);
                this.minutes.add(minute);
                break;
            }
            case WILDCARD: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for minute: " + value);
            }
        }
    }

    public Calendar getNextMinute(Calendar current) {
        GregorianCalendar next = new GregorianCalendar(current.getTimeZone());
        next.setTime(current.getTime());
        Integer currentMinute = current.get(12);
        if (this.expressionType == ScheduleExpressionType.WILDCARD) {
            return current;
        }
        Integer nextMinute = this.minutes.first();
        for (Integer minute : this.minutes) {
            if (currentMinute.equals(minute)) {
                nextMinute = currentMinute;
                break;
            }
            if (minute <= currentMinute) continue;
            nextMinute = minute;
            break;
        }
        if (nextMinute < currentMinute) {
            ((Calendar)next).add(10, 1);
        }
        next.set(12, nextMinute);
        return next;
    }

    public int getFirst() {
        if (this.expressionType == ScheduleExpressionType.WILDCARD) {
            return new GregorianCalendar().get(12);
        }
        return this.minutes.first();
    }

    @Override
    protected Integer getMaxValue() {
        return MAX_MINUTE;
    }

    @Override
    protected Integer getMinValue() {
        return MIN_MINUTE;
    }
}

