/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timer.schedule;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.ejb.ScheduleExpression;
import org.jboss.ejb3.timer.schedule.DayOfMonth;
import org.jboss.ejb3.timer.schedule.DayOfWeek;
import org.jboss.ejb3.timer.schedule.Hour;
import org.jboss.ejb3.timer.schedule.Minute;
import org.jboss.ejb3.timer.schedule.Month;
import org.jboss.ejb3.timer.schedule.Second;
import org.jboss.ejb3.timer.schedule.Year;
import org.jboss.logging.Logger;

public class CalendarBasedTimeout {
    private static Logger logger = Logger.getLogger(CalendarBasedTimeout.class);
    private ScheduleExpression scheduleExpression;
    private Second second;
    private Minute minute;
    private Hour hour;
    private DayOfWeek dayOfWeek;
    private DayOfMonth dayOfMonth;
    private Month month;
    private Year year;
    private Calendar firstTimeout;
    private TimeZone timezone;

    public CalendarBasedTimeout(ScheduleExpression schedule) {
        if (schedule == null) {
            throw new IllegalArgumentException("Cannot create " + this.getClass().getName() + " from a null schedule expression");
        }
        this.nullCheckScheduleAttributes(schedule);
        this.scheduleExpression = this.clone(schedule);
        this.second = new Second(schedule.getSecond());
        this.minute = new Minute(schedule.getMinute());
        this.hour = new Hour(schedule.getHour());
        this.dayOfWeek = new DayOfWeek(schedule.getDayOfWeek());
        this.dayOfMonth = new DayOfMonth(schedule.getDayOfMonth());
        this.month = new Month(schedule.getMonth());
        this.year = new Year(schedule.getYear());
        if (schedule.getTimezone() != null && !schedule.getTimezone().trim().isEmpty()) {
            String timezoneId = schedule.getTimezone();
            String[] availableTimeZoneIDs = TimeZone.getAvailableIDs();
            if (availableTimeZoneIDs != null && Arrays.asList(availableTimeZoneIDs).contains(timezoneId)) {
                this.timezone = TimeZone.getTimeZone(timezoneId);
            } else {
                logger.warn((Object)("Unknown timezone id: " + timezoneId + " found in schedule expression. Ignoring it and using server's timezone: " + TimeZone.getDefault().getID()));
                this.timezone = TimeZone.getDefault();
            }
        } else {
            this.timezone = TimeZone.getDefault();
        }
        this.setFirstTimeout();
    }

    public Calendar getNextTimeout(Calendar current) {
        Calendar next = new GregorianCalendar(this.timezone);
        Date start = this.scheduleExpression.getStart();
        if (start != null && current.getTime().before(start)) {
            next.setTime(start);
        } else {
            next.setTime(current.getTime());
            next.add(13, 1);
        }
        next.setFirstDayOfWeek(1);
        next = this.second.getNextSecond(next);
        next = this.minute.getNextMinute(next);
        next = this.hour.getNextHour(next);
        next = this.dayOfWeek.getNextDayOfWeek(next);
        next = this.dayOfMonth.getNextDayOfMonth(next);
        next = this.month.getNextMonth(next);
        if (next == null) {
            return null;
        }
        next = this.year.getNextYear(next);
        Date end = this.scheduleExpression.getEnd();
        if (next != null && end != null && next.after(end)) {
            return null;
        }
        return next;
    }

    public Calendar getNextTimeout() {
        GregorianCalendar now = new GregorianCalendar(this.timezone);
        now.setTime(new Date());
        return this.getNextTimeout(now);
    }

    public Calendar getFirstTimeout() {
        return this.firstTimeout;
    }

    private void setFirstTimeout() {
        this.firstTimeout = new GregorianCalendar(this.timezone);
        Date start = this.scheduleExpression.getStart();
        if (start != null) {
            this.firstTimeout.setTime(start);
        } else {
            this.firstTimeout.set(13, this.second.getFirst());
            this.firstTimeout.set(12, this.minute.getFirst());
            this.firstTimeout.set(11, this.hour.getFirst());
        }
        this.firstTimeout.setFirstDayOfWeek(1);
        this.firstTimeout = this.second.getNextSecond(this.firstTimeout);
        this.firstTimeout = this.minute.getNextMinute(this.firstTimeout);
        this.firstTimeout = this.hour.getNextHour(this.firstTimeout);
        this.firstTimeout = this.dayOfWeek.getNextDayOfWeek(this.firstTimeout);
        this.firstTimeout = this.dayOfMonth.getNextDayOfMonth(this.firstTimeout);
        this.firstTimeout = this.month.getNextMonth(this.firstTimeout);
        if (this.firstTimeout != null) {
            this.firstTimeout = this.year.getNextYear(this.firstTimeout);
        }
    }

    public ScheduleExpression getScheduleExpression() {
        return this.scheduleExpression;
    }

    private void nullCheckScheduleAttributes(ScheduleExpression schedule) {
        if (schedule.getSecond() == null) {
            throw new IllegalArgumentException("Second cannot be null in schedule expression " + schedule);
        }
        if (schedule.getMinute() == null) {
            throw new IllegalArgumentException("Minute cannot be null in schedule expression " + schedule);
        }
        if (schedule.getHour() == null) {
            throw new IllegalArgumentException("Hour cannot be null in schedule expression " + schedule);
        }
        if (schedule.getDayOfMonth() == null) {
            throw new IllegalArgumentException("day-of-month cannot be null in schedule expression " + schedule);
        }
        if (schedule.getDayOfWeek() == null) {
            throw new IllegalArgumentException("day-of-week cannot be null in schedule expression " + schedule);
        }
        if (schedule.getMonth() == null) {
            throw new IllegalArgumentException("Month cannot be null in schedule expression " + schedule);
        }
        if (schedule.getYear() == null) {
            throw new IllegalArgumentException("Year cannot be null in schedule expression " + schedule);
        }
    }

    private ScheduleExpression clone(ScheduleExpression schedule) {
        ScheduleExpression clonedSchedule = new ScheduleExpression();
        clonedSchedule.second(schedule.getSecond());
        clonedSchedule.minute(schedule.getMinute());
        clonedSchedule.hour(schedule.getHour());
        clonedSchedule.dayOfWeek(schedule.getDayOfWeek());
        clonedSchedule.dayOfMonth(schedule.getDayOfMonth());
        clonedSchedule.month(schedule.getMonth());
        clonedSchedule.year(schedule.getYear());
        clonedSchedule.timezone(schedule.getTimezone());
        clonedSchedule.start(schedule.getStart());
        clonedSchedule.end(schedule.getEnd());
        return clonedSchedule;
    }
}

