/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timer.schedule;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.ejb3.timer.schedule.IntegerBasedExpression;
import org.jboss.ejb3.timer.schedule.ListValue;
import org.jboss.ejb3.timer.schedule.RangeValue;
import org.jboss.ejb3.timer.schedule.ScheduleExpressionType;
import org.jboss.ejb3.timer.schedule.ScheduleExpressionTypeUtil;
import org.jboss.ejb3.timer.schedule.SingleValue;

public class Year
extends IntegerBasedExpression {
    public static final Integer MAX_YEAR = 9999;
    public static final Integer MIN_YEAR = 1000;
    private SortedSet<Integer> years = new TreeSet<Integer>();
    private ScheduleExpressionType expressionType;

    public Year(String value) {
        this.expressionType = ScheduleExpressionTypeUtil.getType(value);
        Set<Integer> yrs = null;
        switch (this.expressionType) {
            case RANGE: {
                RangeValue range = new RangeValue(value);
                yrs = this.processRangeValue(range);
                this.years.addAll(yrs);
                break;
            }
            case LIST: {
                ListValue list = new ListValue(value);
                yrs = this.processListValue(list);
                this.years.addAll(yrs);
                break;
            }
            case SINGLE_VALUE: {
                SingleValue singleValue = new SingleValue(value);
                Integer year = this.processSingleValue(singleValue);
                this.years.add(year);
                break;
            }
            case WILDCARD: {
                break;
            }
            case INCREMENT: {
                throw new IllegalArgumentException("Increment type expression is not allowed for year value. Invalid value: " + value);
            }
            default: {
                throw new IllegalArgumentException("Invalid value for year: " + value);
            }
        }
    }

    @Override
    protected Integer getMaxValue() {
        return MAX_YEAR;
    }

    @Override
    protected Integer getMinValue() {
        return MIN_YEAR;
    }

    public Calendar getNextYear(Calendar current) {
        boolean isFeb29 = this.isFeb29(current);
        if (this.expressionType == ScheduleExpressionType.WILDCARD) {
            if (isFeb29) {
                if (this.isLeapYear(current.get(1))) {
                    return current;
                }
                int nextLeapYear = this.getNextLeapYear(current.get(1));
                current.set(1, nextLeapYear);
                return current;
            }
            return current;
        }
        GregorianCalendar next = new GregorianCalendar(current.getTimeZone());
        next.setTime(current.getTime());
        Integer currentYear = current.get(1);
        Integer nextYear = this.years.first();
        for (Integer year : this.years) {
            if (currentYear.equals(year)) {
                if (isFeb29 && !this.isLeapYear(year)) continue;
                nextYear = currentYear;
                break;
            }
            if (year <= currentYear || isFeb29 && !this.isLeapYear(year)) continue;
            nextYear = year;
            break;
        }
        if (nextYear < currentYear) {
            return null;
        }
        if (isFeb29 && !this.isLeapYear(nextYear)) {
            return null;
        }
        next.set(1, nextYear);
        return next;
    }

    private boolean isFeb29(Calendar cal) {
        int date = cal.get(5);
        int month = cal.get(2);
        return date == 29 && month == 1;
    }

    private boolean isLeapYear(int year) {
        if (this.isDivisibleBy4(year)) {
            if (this.isDivisibleBy100(year)) {
                return this.isDivisibleBy400(year);
            }
            return true;
        }
        return false;
    }

    private boolean isDivisibleBy4(int num) {
        return num % 4 == 0;
    }

    private boolean isDivisibleBy100(int num) {
        return num % 100 == 0;
    }

    private boolean isDivisibleBy400(int num) {
        return num % 400 == 0;
    }

    private int getNextLeapYear(int year) {
        while (!this.isLeapYear(year)) {
            ++year;
        }
        return year;
    }
}

