/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timer.schedule;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.ejb.ScheduleExpression;
import org.jboss.ejb3.timer.schedule.attribute.DayOfMonth;
import org.jboss.ejb3.timer.schedule.attribute.DayOfWeek;
import org.jboss.ejb3.timer.schedule.attribute.Hour;
import org.jboss.ejb3.timer.schedule.attribute.Minute;
import org.jboss.ejb3.timer.schedule.attribute.Month;
import org.jboss.ejb3.timer.schedule.attribute.Second;
import org.jboss.ejb3.timer.schedule.attribute.Year;

public class ScheduleExpressionCalendar
extends GregorianCalendar {
    private boolean dayOfMonthRelative;
    private String relativeDayOfMonth;
    private ScheduleExpression scheduleExpression;
    private Second second;
    private Minute minute;
    private Hour hour;
    private DayOfWeek dayOfWeek;
    private DayOfMonth dayOfMonth;
    private Month month;
    private Year year;

    public ScheduleExpressionCalendar() {
    }

    public ScheduleExpressionCalendar(TimeZone timezone) {
        super(timezone);
    }

    public ScheduleExpressionCalendar(Locale locale) {
        super(locale);
    }

    public ScheduleExpressionCalendar(TimeZone timezone, Locale locale) {
        super(timezone, locale);
    }

    @Override
    protected void computeTime() {
        if (this.dayOfMonthRelative) {
            int lastDayOfCurrentMonth = this.computeAbsoluteDayOfMonth();
            this.internalSet(5, lastDayOfCurrentMonth);
        }
        super.computeTime();
    }

    protected int computeAbsoluteDayOfMonth() {
        if (this.relativeDayOfMonth.equalsIgnoreCase("last")) {
            int lastDayOfCurrentMonth = this.getActualMaximum(5);
            return lastDayOfCurrentMonth;
        }
        return this.get(5);
    }

    public boolean isDayOfMonthRelative() {
        return this.dayOfMonthRelative;
    }

    private void internalSet(int field, int value) {
        this.fields[field] = value;
    }

    public Calendar getNextTimeout(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Calendar nextCal = this.copy(currentCal);
        nextCal.add(13, 1);
        nextCal.set(14, 0);
        nextCal.setFirstDayOfWeek(1);
        nextCal = this.computeNextSecond(nextCal);
        if (nextCal == null) {
            return null;
        }
        if ((nextCal = this.computeNextMinute(nextCal)) == null) {
            return null;
        }
        if ((nextCal = this.computeNextHour(nextCal)) == null) {
            return null;
        }
        if ((nextCal = this.computeNextDayOfWeek(nextCal)) == null) {
            return null;
        }
        if ((nextCal = this.computeNextMonth(nextCal)) == null) {
            return null;
        }
        if ((nextCal = this.computeNextDayOfMonth(nextCal)) == null) {
            return null;
        }
        if ((nextCal = this.computeNextYear(nextCal)) == null) {
            return null;
        }
        if (this.noMoreTimeouts(nextCal)) {
            return null;
        }
        return nextCal;
    }

    private Calendar computeNextSecond(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Integer nextSecond = this.second.getNextMatch(currentCal);
        if (nextSecond == null) {
            return null;
        }
        int currentSecond = currentCal.get(13);
        if (currentSecond == nextSecond) {
            return currentCal;
        }
        Calendar nextCal = this.copy(currentCal);
        if (nextSecond > currentSecond) {
            nextCal.set(13, nextSecond);
            return nextCal;
        }
        if (nextSecond < currentSecond) {
            nextCal.set(13, nextSecond);
            nextCal.add(12, 1);
            return nextCal;
        }
        return null;
    }

    private Calendar computeNextMinute(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Integer nextMinute = this.minute.getNextMatch(currentCal);
        if (nextMinute == null) {
            return null;
        }
        int currentMinute = currentCal.get(12);
        if (currentMinute == nextMinute) {
            return currentCal;
        }
        Calendar nextCal = this.copy(currentCal);
        if (nextMinute > currentMinute) {
            nextCal.set(12, nextMinute);
            nextCal.set(13, this.second.getFirst());
            return nextCal;
        }
        if (nextMinute < currentMinute) {
            nextCal.set(13, this.second.getFirst());
            nextCal.set(12, nextMinute);
            nextCal.add(11, 1);
            return nextCal;
        }
        return null;
    }

    private Calendar computeNextHour(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Integer nextHour = this.hour.getNextMatch(currentCal);
        if (nextHour == null) {
            return null;
        }
        int currentHour = currentCal.get(11);
        if (currentHour == nextHour) {
            return currentCal;
        }
        Calendar nextCal = this.copy(currentCal);
        if (nextHour > currentHour) {
            nextCal.set(11, nextHour);
            nextCal.set(13, this.second.getFirst());
            nextCal.set(12, this.minute.getFirst());
            return nextCal;
        }
        if (nextHour < currentHour) {
            nextCal.set(11, nextHour);
            nextCal.set(13, this.second.getFirst());
            nextCal.set(12, this.minute.getFirst());
            nextCal.add(5, 1);
            return nextCal;
        }
        return null;
    }

    private Calendar computeNextDayOfWeek(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Integer nextDayOfWeek = this.dayOfWeek.getNextMatch(currentCal);
        if (nextDayOfWeek == null) {
            return null;
        }
        int currentDayOfWeek = currentCal.get(7);
        if (currentDayOfWeek == nextDayOfWeek) {
            return currentCal;
        }
        Calendar nextCal = this.copy(currentCal);
        if (nextDayOfWeek > currentDayOfWeek) {
            int dayDiff = nextDayOfWeek - currentDayOfWeek;
            nextCal.add(5, dayDiff);
            nextCal.set(13, this.second.getFirst());
            nextCal.set(12, this.minute.getFirst());
            nextCal.set(11, this.hour.getFirst());
            return nextCal;
        }
        if (nextDayOfWeek < currentDayOfWeek) {
            nextCal.set(7, nextDayOfWeek);
            nextCal.add(4, 1);
            nextCal.set(13, this.second.getFirst());
            nextCal.set(12, this.minute.getFirst());
            nextCal.set(11, this.hour.getFirst());
            return nextCal;
        }
        return null;
    }

    private Calendar computeNextMonth(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Integer nextMonth = this.month.getNextMatch(currentCal);
        if (nextMonth == null) {
            return null;
        }
        int currentMonth = currentCal.get(2);
        if (currentMonth == nextMonth) {
            return currentCal;
        }
        Calendar nextCal = this.copy(currentCal);
        if (nextMonth > currentMonth) {
            nextCal.set(2, nextMonth);
            nextCal.set(13, this.second.getFirst());
            nextCal.set(12, this.minute.getFirst());
            nextCal.set(11, this.hour.getFirst());
            nextCal.set(7, this.dayOfWeek.getFirst());
            return nextCal;
        }
        if (nextMonth < currentMonth) {
            nextCal.set(2, nextMonth);
            nextCal.set(13, this.second.getFirst());
            nextCal.set(12, this.minute.getFirst());
            nextCal.set(11, this.hour.getFirst());
            nextCal.set(7, this.dayOfWeek.getFirst());
            nextCal.add(1, 1);
            return nextCal;
        }
        return null;
    }

    private Calendar computeNextDayOfMonth(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Integer nextDayOfMonth = this.dayOfMonth.getNextMatch(currentCal);
        if (nextDayOfMonth == null) {
            return null;
        }
        int currentDayOfMonth = currentCal.get(5);
        if (currentDayOfMonth == nextDayOfMonth) {
            return currentCal;
        }
        Calendar nextCal = this.copy(currentCal);
        if (nextDayOfMonth > currentDayOfMonth) {
            nextCal.set(5, nextDayOfMonth);
            nextCal.set(13, this.second.getFirst());
            nextCal.set(12, this.minute.getFirst());
            nextCal.set(11, this.hour.getFirst());
        } else if (nextDayOfMonth < currentDayOfMonth) {
            nextCal.set(5, nextDayOfMonth);
            nextCal.set(13, this.second.getFirst());
            nextCal.set(12, this.minute.getFirst());
            nextCal.set(11, this.hour.getFirst());
            nextCal.add(2, 1);
        }
        while (!this.monthHasDate(nextCal, nextDayOfMonth)) {
            if (nextCal.get(1) > Year.MAX_YEAR) {
                return null;
            }
            nextCal.add(2, 1);
            nextCal = this.computeNextMonth(nextCal);
            if (nextCal == null) {
                return null;
            }
            nextDayOfMonth = this.dayOfMonth.getFirstMatch(nextCal);
            if (nextDayOfMonth == null) {
                return null;
            }
            nextCal.set(5, nextDayOfMonth);
        }
        Calendar tmpNextCal = nextCal;
        if ((nextCal = this.computeNextDayOfWeek(nextCal)) == null) {
            return null;
        }
        if (nextCal.getTime().equals(tmpNextCal.getTime())) {
            return nextCal;
        }
        return this.computeNextDayOfMonth(nextCal);
    }

    private Calendar computeNextYear(Calendar currentCal) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Integer nextYear = this.year.getNextMatch(currentCal);
        if (nextYear == null || nextYear > Year.MAX_YEAR) {
            return null;
        }
        int currentYear = currentCal.get(1);
        if (currentYear == nextYear) {
            return currentCal;
        }
        if (nextYear < currentYear) {
            return null;
        }
        Calendar nextCal = this.copy(currentCal);
        nextCal.set(1, nextYear);
        nextCal.set(13, this.second.getFirst());
        nextCal.set(12, this.minute.getFirst());
        nextCal.set(11, this.hour.getFirst());
        nextCal.set(2, this.month.getFirstMatch());
        nextCal = this.computeNextDayOfMonth(nextCal);
        if (nextCal == null) {
            return null;
        }
        return nextCal;
    }

    private Calendar copy(Calendar cal) {
        GregorianCalendar copy = new GregorianCalendar(cal.getTimeZone());
        copy.setTime(cal.getTime());
        return copy;
    }

    private boolean monthHasDate(Calendar cal, int date) {
        int maximumPossibleDateForTheMonth = cal.getActualMaximum(5);
        return date <= maximumPossibleDateForTheMonth;
    }

    private boolean isAfterEnd(Calendar cal) {
        Date end = this.scheduleExpression.getEnd();
        if (end == null) {
            return false;
        }
        return cal.getTime().after(end);
    }

    private boolean noMoreTimeouts(Calendar cal) {
        return cal.get(1) > Year.MAX_YEAR || this.isAfterEnd(cal);
    }
}

