/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2;

import java.io.Serializable;
import java.util.Calendar;
import java.util.UUID;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.ScheduleExpression;
import org.jboss.ejb3.timer.schedule.CalendarBasedTimeout;
import org.jboss.ejb3.timerservice.mk2.TimerImpl;
import org.jboss.ejb3.timerservice.mk2.TimerServiceImpl;
import org.jboss.ejb3.timerservice.mk2.persistence.CalendarTimerEntity;
import org.jboss.ejb3.timerservice.mk2.persistence.TimeoutMethod;
import org.jboss.ejb3.timerservice.mk2.persistence.TimerEntity;
import org.jboss.ejb3.timerservice.mk2.task.CalendarTimerTask;
import org.jboss.ejb3.timerservice.mk2.task.TimerTask;
import org.jboss.logging.Logger;

public class CalendarTimer
extends TimerImpl {
    private static Logger logger = Logger.getLogger(CalendarTimer.class);
    private CalendarBasedTimeout calendarTimeout;
    private boolean autoTimer;
    private String timeoutMethodName;
    private String[] timeoutMethodParams;

    public CalendarTimer(UUID id, TimerServiceImpl timerService, CalendarBasedTimeout calendarTimeout) {
        this(id, timerService, calendarTimeout, null, true);
    }

    public CalendarTimer(UUID id, TimerServiceImpl timerService, CalendarBasedTimeout calendarTimeout, Serializable info, boolean persistent) {
        this(id, timerService, calendarTimeout, info, persistent, null, null);
    }

    public CalendarTimer(UUID id, TimerServiceImpl timerService, CalendarBasedTimeout calendarTimeout, Serializable info, boolean persistent, String timeoutMethodName, String[] timeoutMethodParams) {
        super(id, timerService, calendarTimeout.getFirstTimeout().getTime(), 0L, info, persistent);
        this.calendarTimeout = calendarTimeout;
        Calendar nextTimeout = this.calendarTimeout.getNextTimeout();
        if (nextTimeout != null) {
            this.nextExpiration = nextTimeout.getTime();
        }
        if (timeoutMethodName != null) {
            this.autoTimer = true;
            this.timeoutMethodName = timeoutMethodName;
            this.timeoutMethodParams = timeoutMethodParams;
        }
    }

    public CalendarTimer(CalendarTimerEntity persistedCalendarTimer, TimerServiceImpl timerService) {
        super(persistedCalendarTimer, timerService);
        this.calendarTimeout = persistedCalendarTimer.getCalendarTimeout();
        this.nextExpiration = persistedCalendarTimer.getNextDate();
        if (persistedCalendarTimer.isAutoTimer()) {
            this.autoTimer = true;
            TimeoutMethod timeoutMethod = persistedCalendarTimer.getTimeoutMethod();
            this.timeoutMethodName = timeoutMethod.getMethodName();
            this.timeoutMethodParams = timeoutMethod.getMethodParams();
        }
    }

    @Override
    public ScheduleExpression getSchedule() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimerState();
        return this.calendarTimeout.getScheduleExpression();
    }

    @Override
    public boolean isCalendarTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimerState();
        return true;
    }

    @Override
    protected TimerEntity createPersistentState() {
        return new CalendarTimerEntity(this);
    }

    public CalendarBasedTimeout getCalendarTimeout() {
        return this.calendarTimeout;
    }

    @Override
    public boolean isAutoTimer() {
        return this.autoTimer;
    }

    public String getTimeoutMethod() {
        if (!this.autoTimer) {
            throw new IllegalStateException("Cannot invoke getTimeoutMethod on a timer which is not an auto-timer");
        }
        return this.timeoutMethodName;
    }

    public String[] getTimeoutMethodParams() {
        if (!this.autoTimer) {
            throw new IllegalStateException("Cannot invoke getTimeoutMethodParams on a timer which is not an auto-timer");
        }
        return this.timeoutMethodParams;
    }

    @Override
    protected TimerTask<?> getTimerTask() {
        return new CalendarTimerTask(this);
    }
}

