/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.ejb.EJBException;
import javax.ejb.NoMoreTimeoutsException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.ScheduleExpression;
import javax.ejb.TimerHandle;
import org.jboss.ejb3.timerservice.extension.Timer;
import org.jboss.ejb3.timerservice.mk2.TimerHandleImpl;
import org.jboss.ejb3.timerservice.mk2.TimerServiceImpl;
import org.jboss.ejb3.timerservice.mk2.TimerState;
import org.jboss.ejb3.timerservice.mk2.persistence.TimerEntity;
import org.jboss.ejb3.timerservice.mk2.task.TimerTask;
import org.jboss.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.logging.Logger;

public class TimerImpl
implements Timer {
    private static final Logger logger = Logger.getLogger(TimerImpl.class);
    protected UUID id;
    protected TimerState timerState;
    protected TimerServiceImpl timerService;
    protected TimedObjectInvoker timedObjectInvoker;
    protected Serializable info;
    protected boolean persistent;
    protected TimerHandleImpl handle;
    protected Date initialExpiration;
    protected long intervalDuration;
    protected Date nextExpiration;
    protected ScheduledFuture<?> future;
    protected Date previousRun;
    protected TimerEntity persistentState;

    public TimerImpl(UUID id, TimerServiceImpl service, Date initialExpiry, long intervalDuration, Serializable info, boolean persistent) {
        this(id, service, initialExpiry, intervalDuration, initialExpiry, info, persistent);
    }

    public TimerImpl(UUID id, TimerServiceImpl service, Date initialExpiry, long intervalDuration, Date nextEpiry, Serializable info, boolean persistent) {
        assert (service != null) : "service is null";
        assert (id != null) : "id is null";
        this.id = id;
        this.timerService = service;
        this.timerService.addTimer(this);
        this.timedObjectInvoker = service.getInvoker();
        this.info = info;
        this.persistent = persistent;
        this.initialExpiration = initialExpiry;
        this.intervalDuration = intervalDuration;
        this.nextExpiration = nextEpiry;
        this.previousRun = null;
        this.handle = new TimerHandleImpl(this.id, this.timedObjectInvoker.getTimedObjectId(), service);
        this.setTimerState(TimerState.CREATED);
    }

    public TimerImpl(TimerEntity persistedTimer, TimerServiceImpl service) {
        this(persistedTimer.getId(), service, persistedTimer.getInitialDate(), persistedTimer.getInterval(), persistedTimer.getNextDate(), persistedTimer.getInfo(), true);
        this.previousRun = persistedTimer.getPreviousRun();
    }

    public UUID getId() {
        return this.id;
    }

    public boolean isCalendarTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimerState();
        return false;
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimerState();
        this.cancelTimer();
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        return this.handle;
    }

    public boolean isPersistent() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        return this.persistent;
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        return this.info;
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimerState();
        return this.nextExpiration;
    }

    public void setNextTimeout(Date next) {
        this.nextExpiration = next;
    }

    public ScheduleExpression getSchedule() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimerState();
        throw new IllegalStateException("Timer " + this + " is not a calendar based timer");
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimerState();
        if (this.nextExpiration == null) {
            throw new NoMoreTimeoutsException("No more timeouts for timer " + this);
        }
        long currentTimeInMillis = System.currentTimeMillis();
        long nextTimeoutInMillis = this.nextExpiration.getTime();
        return nextTimeoutInMillis - currentTimeInMillis;
    }

    public boolean isAutoTimer() {
        return false;
    }

    protected void cancelTimer() {
        if (this.timerState != TimerState.EXPIRED) {
            this.setTimerState(TimerState.CANCELED);
        }
        this.future.cancel(false);
        this.timerService.persistTimer(this);
    }

    public Date getInitialExpiration() {
        return this.initialExpiration;
    }

    public long getInterval() {
        return this.intervalDuration;
    }

    public String getTimedObjectId() {
        return this.timerService.getInvoker().getTimedObjectId();
    }

    public TimerServiceImpl getTimerService() {
        return this.timerService;
    }

    public boolean isActive() {
        return !this.isCanceled() && !this.isExpired();
    }

    public boolean isCanceled() {
        return this.timerState == TimerState.CANCELED_IN_TX || this.timerState == TimerState.CANCELED;
    }

    public boolean isExpired() {
        return this.timerState == TimerState.EXPIRED;
    }

    public boolean isInRetry() {
        return this.timerState == TimerState.RETRY_TIMEOUT;
    }

    public Date getPreviousRun() {
        return this.previousRun;
    }

    public void setPreviousRun(Date previousRun) {
        this.previousRun = previousRun;
    }

    public TimerState getState() {
        return this.timerState;
    }

    protected void assertTimerState() {
        if (this.timerState == TimerState.EXPIRED) {
            throw new NoSuchObjectLocalException("Timer has expired");
        }
        if (this.timerState == TimerState.CANCELED_IN_TX || this.timerState == TimerState.CANCELED) {
            throw new NoSuchObjectLocalException("Timer was canceled");
        }
    }

    public void expireTimer() {
        logger.debug((Object)("expireTimer: " + this));
        this.setTimerState(TimerState.EXPIRED);
        this.timerService.removeTimer(this);
        this.future.cancel(false);
        this.timerService.persistTimer(this);
    }

    public void setTimerState(TimerState state) {
        this.timerState = state;
    }

    public TimerEntity getPersistentState() {
        if (!this.persistent) {
            throw new IllegalStateException("Timer " + this + " is not persistent");
        }
        if (this.persistentState == null) {
            this.persistentState = this.createPersistentState();
        } else {
            this.persistentState.setNextDate(this.nextExpiration);
            this.persistentState.setPreviousRun(this.previousRun);
            this.persistentState.setTimerState(this.timerState);
        }
        return this.persistentState;
    }

    public void suspend() {
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    public void scheduleTimeout() {
        TimerTask<?> timerTask = this.getTimerTask();
        long delay = this.nextExpiration.getTime() - System.currentTimeMillis();
        if (delay < 0L) {
            delay = 0L;
        }
        if (this.intervalDuration > 0L) {
            logger.debug((Object)("Scheduling timer " + this + " at fixed rate, starting at " + delay + " milli seconds from now with repeated interval=" + this.intervalDuration));
            this.future = this.timerService.getExecutor().scheduleAtFixedRate(timerTask, delay, this.intervalDuration, TimeUnit.MILLISECONDS);
        } else {
            logger.debug((Object)("Scheduling a single action timer " + this + " starting at " + delay + " milli seconds from now"));
            this.future = this.getTimerService().getExecutor().schedule(timerTask, delay, TimeUnit.MILLISECONDS);
        }
    }

    protected TimerEntity createPersistentState() {
        return new TimerEntity(this);
    }

    protected TimerTask<?> getTimerTask() {
        return new TimerTask<TimerImpl>(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[id=");
        sb.append(this.id);
        sb.append(" ");
        sb.append("timedObjectId=");
        if (this.timedObjectInvoker == null) {
            sb.append("null");
        } else {
            sb.append(this.timedObjectInvoker.getTimedObjectId());
        }
        sb.append(" ");
        sb.append("auto-timer?:");
        sb.append(this.isAutoTimer());
        sb.append(" ");
        sb.append("persistent?:");
        sb.append(this.persistent);
        sb.append(" ");
        sb.append("timerService=");
        sb.append(this.timerService);
        sb.append(" ");
        sb.append("initialExpiration=");
        sb.append(this.initialExpiration);
        sb.append(" ");
        sb.append("intervalDuration(in milli sec)=");
        sb.append(this.intervalDuration);
        sb.append(" ");
        sb.append("nextExpiration=");
        sb.append(this.nextExpiration);
        sb.append(" ");
        sb.append("timerState=");
        sb.append((Object)this.timerState);
        return sb.toString();
    }
}

