/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.ejb.TimerService;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.transaction.TransactionManager;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.ejb3.timerservice.mk2.TimerServiceImpl;
import org.jboss.ejb3.timerservice.mk2.TimerServiceRegistry;
import org.jboss.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.ejb3.timerservice.spi.TimerServiceFactory;
import org.jboss.logging.Logger;

public class TimerServiceFactoryImpl
implements TimerServiceFactory {
    private static final Logger logger = Logger.getLogger(TimerServiceFactoryImpl.class);
    private EntityManagerFactory emf;
    private TransactionManager transactionManager;
    private ScheduledExecutorService executor;

    public TimerService createTimerService(TimedObjectInvoker invoker) {
        this.executor = Executors.newScheduledThreadPool(10);
        TimerServiceImpl timerService = new TimerServiceImpl(invoker, this.emf.createEntityManager(), this.transactionManager, this.executor);
        TimerServiceRegistry.registerTimerService(timerService);
        return timerService;
    }

    public void restoreTimerService(TimerService timerService) {
        TimerServiceImpl mk2TimerService = (TimerServiceImpl)timerService;
        String timedObjectId = mk2TimerService.getInvoker().getTimedObjectId();
        if (!TimerServiceRegistry.isRegistered(timedObjectId)) {
            TimerServiceRegistry.registerTimerService(mk2TimerService);
        }
        logger.debug((Object)("Restoring timerservice for timedObjectId: " + timedObjectId));
        mk2TimerService.restoreTimers();
    }

    @PersistenceUnit(unitName="timerdb")
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Inject
    public void setTransactionManager(TransactionManager tm) {
        this.transactionManager = tm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendTimerService(TimerService timerService) {
        TimerServiceImpl mk2TimerService = (TimerServiceImpl)timerService;
        try {
            logger.debug((Object)("Suspending timerservice for timedObjectId: " + mk2TimerService.getInvoker().getTimedObjectId()));
            mk2TimerService.suspendTimers();
        }
        finally {
            String timedObjectId = mk2TimerService.getInvoker().getTimedObjectId();
            if (TimerServiceRegistry.isRegistered(timedObjectId)) {
                TimerServiceRegistry.unregisterTimerService(timedObjectId);
            }
        }
    }
}

