/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2.task;

import javax.ejb.Timer;
import org.jboss.ejb3.timerservice.mk2.CalendarTimer;
import org.jboss.ejb3.timerservice.mk2.task.TimerTask;
import org.jboss.ejb3.timerservice.spi.MultiTimeoutMethodTimedObjectInvoker;
import org.jboss.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.logging.Logger;

public class CalendarTimerTask
extends TimerTask<CalendarTimer> {
    private static Logger logger = Logger.getLogger(CalendarTimerTask.class);

    public CalendarTimerTask(CalendarTimer calendarTimer) {
        super(calendarTimer);
    }

    @Override
    protected void handleTimeout() throws Exception {
        CalendarTimer calendarTimer = (CalendarTimer)this.getTimer();
        calendarTimer.scheduleTimeout();
        if (calendarTimer.isAutoTimer()) {
            TimedObjectInvoker invoker = this.timerService.getInvoker();
            if (!(invoker instanceof MultiTimeoutMethodTimedObjectInvoker)) {
                String msg = "Cannot invoke timeout method because timer: " + calendarTimer + " is an auto timer, but invoker is not of type" + MultiTimeoutMethodTimedObjectInvoker.class;
                logger.error((Object)msg);
                throw new RuntimeException(msg);
            }
            ((MultiTimeoutMethodTimedObjectInvoker)invoker).callTimeout((Timer)calendarTimer, calendarTimer.getTimeoutMethod(), calendarTimer.getTimeoutMethodParams());
        } else {
            this.timerService.getInvoker().callTimeout((Timer)calendarTimer);
        }
    }
}

