/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2.task;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jboss.ejb3.timerservice.mk2.CalendarTimer;
import org.jboss.ejb3.timerservice.mk2.TimerImpl;
import org.jboss.ejb3.timerservice.mk2.TimerServiceImpl;
import org.jboss.ejb3.timerservice.mk2.TimerState;
import org.jboss.logging.Logger;

public class TimerTask<T extends TimerImpl>
implements Runnable {
    private static Logger logger = Logger.getLogger(TimerTask.class);
    protected T timer;
    protected TimerServiceImpl timerService;

    public TimerTask(T timer) {
        if (timer == null) {
            throw new IllegalArgumentException("Timer cannot be null");
        }
        this.timer = timer;
        this.timerService = ((TimerImpl)timer).getTimerService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug((Object)("run: " + this.timer));
        ((TimerImpl)this.timer).setPreviousRun(new Date());
        long intervalDuration = ((TimerImpl)this.timer).getInterval();
        if (((TimerImpl)this.timer).isActive()) {
            Date nextExpiration;
            if (((TimerImpl)this.timer).isCalendarTimer()) {
                nextExpiration = ((TimerImpl)this.timer).getNextTimeout();
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(nextExpiration);
                Calendar nextTimeout = ((CalendarTimer)this.timer).getCalendarTimeout().getNextTimeout((Calendar)cal);
                ((TimerImpl)this.timer).setNextTimeout(nextTimeout.getTime());
            } else if (intervalDuration > 0L) {
                nextExpiration = ((TimerImpl)this.timer).getNextTimeout();
                nextExpiration = new Date(nextExpiration.getTime() + intervalDuration);
                ((TimerImpl)this.timer).setNextTimeout(nextExpiration);
            }
        }
        this.timerService.persistTimer((TimerImpl)this.timer);
        if (((TimerImpl)this.timer).isInRetry()) {
            logger.debug((Object)"Timer in retry mode, skipping this scheduled execution");
            return;
        }
        if (((TimerImpl)this.timer).isActive()) {
            try {
                ((TimerImpl)this.timer).setTimerState(TimerState.IN_TIMEOUT);
                this.timerService.persistTimer((TimerImpl)this.timer);
                this.handleTimeout();
            }
            catch (Exception e) {
                logger.error((Object)"Error invoking ejbTimeout", (Throwable)e);
            }
            finally {
                TimerState timerState = ((TimerImpl)this.timer).getState();
                if (timerState == TimerState.IN_TIMEOUT) {
                    if (intervalDuration == 0L && !((TimerImpl)this.timer).isCalendarTimer()) {
                        ((TimerImpl)this.timer).expireTimer();
                    } else {
                        ((TimerImpl)this.timer).setTimerState(TimerState.ACTIVE);
                        this.timerService.persistTimer((TimerImpl)this.timer);
                    }
                }
            }
        }
    }

    protected void handleTimeout() throws Exception {
        this.timerService.getInvoker().callTimeout(this.timer);
    }

    protected T getTimer() {
        return this.timer;
    }
}

