/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2.persistence;

import java.lang.reflect.Method;
import java.util.Date;
import javax.ejb.ScheduleExpression;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.jboss.ejb3.timer.schedule.CalendarBasedTimeout;
import org.jboss.ejb3.timerservice.mk2.CalendarTimer;
import org.jboss.ejb3.timerservice.mk2.persistence.TimeoutMethod;
import org.jboss.ejb3.timerservice.mk2.persistence.TimerEntity;

@Entity
@Table(name="calendar_timer")
@Inheritance(strategy=InheritanceType.JOINED)
public class CalendarTimerEntity
extends TimerEntity {
    @Transient
    private ScheduleExpression scheduleExpression;
    @Transient
    private CalendarBasedTimeout calendarTimeout;
    private String scheduleExprSecond;
    private String scheduleExprMinute;
    private String scheduleExprHour;
    private String scheduleExprDayOfWeek;
    private String scheduleExprDayOfMonth;
    private String scheduleExprMonth;
    private String scheduleExprYear;
    private Date scheduleExprStartDate;
    private Date scheduleExprEndDate;
    private String scheduleExprTimezone;
    private boolean autoTimer;
    @OneToOne(cascade={CascadeType.ALL})
    private TimeoutMethod timeoutMethod;

    public CalendarTimerEntity() {
    }

    public CalendarTimerEntity(CalendarTimer calendarTimer) {
        super(calendarTimer);
        this.scheduleExpression = calendarTimer.getScheduleExpression();
        this.autoTimer = calendarTimer.isAutoTimer();
        if (calendarTimer.isAutoTimer()) {
            Method method = calendarTimer.getTimeoutMethod();
            Class<?>[] methodParams = method.getParameterTypes();
            String[] params = new String[methodParams.length];
            for (int i = 0; i < methodParams.length; ++i) {
                params[i] = methodParams[i].getName();
            }
            this.timeoutMethod = new TimeoutMethod(method.getDeclaringClass().getName(), method.getName(), params);
        }
        this.scheduleExprSecond = this.scheduleExpression.getSecond();
        this.scheduleExprMinute = this.scheduleExpression.getMinute();
        this.scheduleExprHour = this.scheduleExpression.getHour();
        this.scheduleExprDayOfMonth = this.scheduleExpression.getDayOfMonth();
        this.scheduleExprMonth = this.scheduleExpression.getMonth();
        this.scheduleExprDayOfWeek = this.scheduleExpression.getDayOfWeek();
        this.scheduleExprYear = this.scheduleExpression.getYear();
        this.scheduleExprStartDate = this.scheduleExpression.getStart();
        this.scheduleExprEndDate = this.scheduleExpression.getEnd();
        this.scheduleExprTimezone = this.scheduleExpression.getTimezone();
    }

    @Override
    public boolean isCalendarTimer() {
        return true;
    }

    public ScheduleExpression getScheduleExpression() {
        if (this.scheduleExpression == null) {
            this.scheduleExpression = new ScheduleExpression();
            this.scheduleExpression.second(this.scheduleExprSecond).minute(this.scheduleExprMinute).hour(this.scheduleExprHour).dayOfWeek(this.scheduleExprDayOfWeek).dayOfMonth(this.scheduleExprDayOfMonth).month(this.scheduleExprMonth).year(this.scheduleExprYear).timezone(this.scheduleExprTimezone);
        }
        return this.scheduleExpression;
    }

    public CalendarBasedTimeout getCalendarTimeout() {
        if (this.calendarTimeout == null) {
            this.calendarTimeout = new CalendarBasedTimeout(this.getScheduleExpression());
        }
        return this.calendarTimeout;
    }

    public String getSecond() {
        return this.scheduleExprSecond;
    }

    public String getMinute() {
        return this.scheduleExprMinute;
    }

    public String getHour() {
        return this.scheduleExprHour;
    }

    public String getDayOfWeek() {
        return this.scheduleExprDayOfWeek;
    }

    public String getDayOfMonth() {
        return this.scheduleExprDayOfMonth;
    }

    public String getMonth() {
        return this.scheduleExprMonth;
    }

    public String getYear() {
        return this.scheduleExprYear;
    }

    public Date getStartDate() {
        return this.scheduleExprStartDate;
    }

    public void setStartDate(Date start) {
        this.scheduleExprStartDate = start;
    }

    public Date getEndDate() {
        return this.scheduleExprEndDate;
    }

    public void setEndDate(Date end) {
        this.scheduleExprEndDate = end;
    }

    public TimeoutMethod getTimeoutMethod() {
        return this.timeoutMethod;
    }

    public void setTimeoutMethod(TimeoutMethod timeoutMethod) {
        this.timeoutMethod = timeoutMethod;
    }

    public boolean isAutoTimer() {
        return this.autoTimer;
    }

    public void setAutoTimer(boolean autoTimer) {
        this.autoTimer = autoTimer;
    }

    public String getTimezone() {
        return this.scheduleExprTimezone;
    }

    public void setTimezone(String timezone) {
        this.scheduleExprTimezone = timezone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalendarTimerEntity)) {
            return false;
        }
        CalendarTimerEntity other = (CalendarTimerEntity)obj;
        if (this.id == null) {
            return false;
        }
        return this.id.equals(other.id);
    }

    @Override
    public int hashCode() {
        if (this.id == null) {
            return super.hashCode();
        }
        return this.id.hashCode();
    }
}

