/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2.persistence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="Timeout_Method")
public class TimeoutMethod
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @NotNull(message="Declaring class for timeout method cannot be null")
    private String declaringClass;
    @NotNull(message="Method name for timeout method cannot be null")
    private String methodName;
    @ElementCollection
    private List<String> methodParams;
    private String cachedToString;

    public TimeoutMethod() {
    }

    public TimeoutMethod(String declaringClass, String methodName, String[] methodParams) {
        this.declaringClass = declaringClass;
        this.methodName = methodName;
        if (methodParams != null) {
            this.methodParams = new ArrayList<String>(Arrays.asList(methodParams));
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getMethodParams() {
        if (this.methodParams == null) {
            return null;
        }
        return this.methodParams.toArray(new String[0]);
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String toString() {
        if (this.cachedToString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.declaringClass);
            sb.append(".");
            sb.append(this.methodName);
            sb.append("(");
            if (this.methodParams != null) {
                for (int i = 0; i < this.methodParams.size(); ++i) {
                    sb.append(this.methodParams.get(i));
                    if (i == this.methodParams.size() - 1) continue;
                    sb.append(",");
                }
            }
            sb.append(")");
            this.cachedToString = sb.toString();
        }
        return this.cachedToString;
    }
}

