/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2.task;

import java.util.Date;
import org.jboss.ejb3.timerservice.mk2.TimerImpl;
import org.jboss.ejb3.timerservice.mk2.TimerServiceImpl;
import org.jboss.ejb3.timerservice.mk2.TimerState;
import org.jboss.logging.Logger;

public class TimerTask<T extends TimerImpl>
implements Runnable {
    private static Logger logger = Logger.getLogger(TimerTask.class);
    protected T timer;
    protected TimerServiceImpl timerService;

    public TimerTask(T timer) {
        if (timer == null) {
            throw new IllegalArgumentException("Timer cannot be null");
        }
        this.timer = timer;
        this.timerService = ((TimerImpl)timer).getTimerService();
    }

    @Override
    public void run() {
        Date now = new Date();
        logger.debug((Object)("Timer task invoked at: " + now + " for timer " + this.timer));
        if (((TimerImpl)this.timer).isInRetry()) {
            logger.debug((Object)("Timer in retry mode, skipping this scheduled execution at: " + now));
            return;
        }
        if (!((TimerImpl)this.timer).isActive()) {
            logger.debug((Object)("Timer is not active, skipping this scheduled execution at: " + now));
        }
        ((TimerImpl)this.timer).setPreviousRun(new Date());
        Date nextTimeout = this.calculateNextTimeout();
        ((TimerImpl)this.timer).setNextTimeout(nextTimeout);
        ((TimerImpl)this.timer).setTimerState(TimerState.IN_TIMEOUT);
        this.timerService.persistTimer((TimerImpl)this.timer);
        try {
            this.handleTimeout();
        }
        catch (Exception e) {
            logger.error((Object)"Error invoking ejbTimeout", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTimeout() throws Exception {
        try {
            this.timerService.getInvoker().callTimeout(this.timer);
        }
        finally {
            TimerState timerState = ((TimerImpl)this.timer).getState();
            if (timerState == TimerState.IN_TIMEOUT) {
                if (((TimerImpl)this.timer).getInterval() == 0L) {
                    ((TimerImpl)this.timer).expireTimer();
                } else {
                    ((TimerImpl)this.timer).setTimerState(TimerState.ACTIVE);
                    this.timerService.persistTimer((TimerImpl)this.timer);
                }
            }
        }
    }

    protected Date calculateNextTimeout() {
        long intervalDuration = ((TimerImpl)this.timer).getInterval();
        if (intervalDuration > 0L) {
            Date nextExpiration = ((TimerImpl)this.timer).getNextExpiration();
            nextExpiration = new Date(nextExpiration.getTime() + intervalDuration);
            return nextExpiration;
        }
        return null;
    }

    protected T getTimer() {
        return this.timer;
    }
}

