/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2.task;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.ejb.Timer;
import org.jboss.ejb3.timerservice.mk2.CalendarTimer;
import org.jboss.ejb3.timerservice.mk2.TimerState;
import org.jboss.ejb3.timerservice.mk2.task.TimerTask;
import org.jboss.ejb3.timerservice.spi.MultiTimeoutMethodTimedObjectInvoker;
import org.jboss.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.logging.Logger;

public class CalendarTimerTask
extends TimerTask<CalendarTimer> {
    private static Logger logger = Logger.getLogger(CalendarTimerTask.class);

    public CalendarTimerTask(CalendarTimer calendarTimer) {
        super(calendarTimer);
    }

    @Override
    protected void callTimeout() throws Exception {
        CalendarTimer calendarTimer = (CalendarTimer)this.getTimer();
        if (calendarTimer.getNextExpiration() != null && !calendarTimer.isInRetry()) {
            calendarTimer.scheduleTimeout();
        }
        if (calendarTimer.isAutoTimer()) {
            TimedObjectInvoker invoker = this.timerService.getInvoker();
            if (!(invoker instanceof MultiTimeoutMethodTimedObjectInvoker)) {
                String msg = "Cannot invoke timeout method because timer: " + calendarTimer + " is an auto timer, but invoker is not of type" + MultiTimeoutMethodTimedObjectInvoker.class;
                logger.error((Object)msg);
                throw new RuntimeException(msg);
            }
            ((MultiTimeoutMethodTimedObjectInvoker)invoker).callTimeout((Timer)calendarTimer, calendarTimer.getTimeoutMethod());
        } else {
            this.timerService.getInvoker().callTimeout((Timer)calendarTimer);
        }
    }

    @Override
    protected Date calculateNextTimeout() {
        Date currentTimeout = ((CalendarTimer)this.getTimer()).getNextExpiration();
        if (currentTimeout == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(currentTimeout);
        Calendar nextTimeout = ((CalendarTimer)this.getTimer()).getCalendarTimeout().getNextTimeout((Calendar)cal);
        if (nextTimeout != null) {
            return nextTimeout.getTime();
        }
        return null;
    }

    @Override
    protected void postTimeoutProcessing() {
        CalendarTimer calendarTimer = (CalendarTimer)this.getTimer();
        TimerState timerState = calendarTimer.getState();
        if (timerState == TimerState.IN_TIMEOUT || timerState == TimerState.RETRY_TIMEOUT) {
            if (calendarTimer.getNextExpiration() == null) {
                calendarTimer.expireTimer();
            } else {
                calendarTimer.setTimerState(TimerState.ACTIVE);
                this.timerService.persistTimer(calendarTimer);
            }
        }
    }
}

