/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.el.parser;

import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.PropertyNotFoundException;
import org.jboss.el.lang.EvaluationContext;
import org.jboss.el.parser.SimpleNode;
import org.jboss.el.parser.ValueSuffixNode;
import org.jboss.el.util.MessageFactory;

public final class AstValue
extends SimpleNode {
    public AstValue(int id) {
        super(id);
    }

    public Class getType(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        return t.node.getType(t.base, ctx);
    }

    private final Target getTarget(EvaluationContext ctx) throws ELException {
        Object base = this.children[0].getValue(ctx);
        if (base == null) {
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.base", this.children[0].getImage()));
        }
        int propCount = this.jjtGetNumChildren() - 1;
        for (int i = 1; base != null && i < propCount; ++i) {
            base = ((ValueSuffixNode)this.children[i]).getTarget(base, ctx);
            if (base != null) continue;
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.base", this.children[0].getImage()));
        }
        Target t = new Target();
        t.base = base;
        t.node = (ValueSuffixNode)this.children[propCount];
        return t;
    }

    public Object getValue(EvaluationContext ctx) throws ELException {
        Object base = this.children[0].getValue(ctx);
        int propCount = this.jjtGetNumChildren();
        int i = 1;
        while (base != null && i < propCount) {
            if ((base = ((ValueSuffixNode)this.children[i]).getValue(base, ctx)) == null) {
                return base;
            }
            ++i;
        }
        return base;
    }

    public boolean isReadOnly(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        return t.node.isReadOnly(t.base, ctx);
    }

    public void setValue(EvaluationContext ctx, Object value) throws ELException {
        Target t = this.getTarget(ctx);
        t.node.setValue(t.base, ctx, value);
    }

    public MethodInfo getMethodInfo(EvaluationContext ctx, Class[] paramTypes) throws ELException {
        Target t = this.getTarget(ctx);
        return t.node.getMethodInfo(t.base, ctx, paramTypes);
    }

    public Object invoke(EvaluationContext ctx, Class[] paramTypes, Object[] paramValues) throws ELException {
        Target t = this.getTarget(ctx);
        return t.node.invoke(t.base, ctx, paramTypes, paramValues);
    }

    protected static class Target {
        protected Object base;
        protected ValueSuffixNode node;

        protected Target() {
        }
    }
}

