/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.el.parser;

import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.PropertyNotWritableException;
import org.jboss.el.lang.ELSupport;
import org.jboss.el.lang.EvaluationContext;
import org.jboss.el.parser.ELParserTreeConstants;
import org.jboss.el.parser.Node;
import org.jboss.el.parser.NodeVisitor;
import org.jboss.el.util.MessageFactory;

public abstract class SimpleNode
extends ELSupport
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected String image;

    public SimpleNode(int i) {
        this.id = i;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        if (this.image != null) {
            return String.valueOf(ELParserTreeConstants.jjtNodeName[this.id]) + "[" + this.image + "]";
        }
        return ELParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return String.valueOf(prefix) + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    n.dump(String.valueOf(prefix) + " ");
                }
                ++i;
            }
        }
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Class getType(EvaluationContext ctx) throws ELException {
        throw new UnsupportedOperationException();
    }

    public Object getValue(EvaluationContext ctx) throws ELException {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly(EvaluationContext ctx) throws ELException {
        return true;
    }

    public void setValue(EvaluationContext ctx, Object value) throws ELException {
        throw new PropertyNotWritableException(MessageFactory.get("error.syntax.set"));
    }

    public void accept(NodeVisitor visitor) throws Exception {
        visitor.visit(this);
        if (this.children != null && this.children.length > 0) {
            int i = 0;
            while (i < this.children.length) {
                this.children[i].accept(visitor);
                ++i;
            }
        }
    }

    public Object invoke(EvaluationContext ctx, Class[] paramTypes, Object[] paramValues) throws ELException {
        throw new UnsupportedOperationException();
    }

    public MethodInfo getMethodInfo(EvaluationContext ctx, Class[] paramTypes) throws ELException {
        throw new UnsupportedOperationException();
    }
}

