/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.el.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferenceCache<K, V> {
    private final ConcurrentMap<ReferenceKey<K>, Future<ReferenceValue<V>>> cache;
    private final ReferenceFactory keyFactory;
    private final ReferenceFactory valueFactory;
    private final ReferenceFactory lookupFactory;
    private final ReferenceQueueRunner queue;
    private Thread queueMonitor;

    public ReferenceCache(Type keyType, Type valueType) {
        this(keyType, valueType, 0);
    }

    public ReferenceCache(Type keyType, Type valueType, int initialSize) {
        this.keyFactory = this.toFactory(keyType);
        this.valueFactory = this.toFactory(valueType);
        this.lookupFactory = new StrongReferenceFactory();
        this.cache = new ConcurrentHashMap<ReferenceKey<K>, Future<ReferenceValue<V>>>(initialSize);
        this.queue = new ReferenceQueueRunner();
    }

    public void startMonitor() {
        if (this.queueMonitor == null) {
            this.queueMonitor = new Thread(this.queue);
            this.queueMonitor.setName("jboss EL reference queue cleanup thread");
            this.queueMonitor.setDaemon(true);
            this.queueMonitor.start();
        }
    }

    public void stopMonitor() {
        if (this.queueMonitor != null) {
            this.queueMonitor.interrupt();
            this.queueMonitor = null;
        }
    }

    private final ReferenceFactory<K, V> toFactory(Type type) {
        switch (type) {
            case Strong: {
                return new StrongReferenceFactory();
            }
            case Weak: {
                return new WeakReferenceFactory();
            }
            case Soft: {
                return new SoftReferenceFactory();
            }
        }
        throw new IllegalArgumentException("Invalid ReferenceType: " + (Object)((Object)type));
    }

    protected abstract V create(K var1);

    public V get(final Object key) {
        try {
            ReferenceKey<Object> refKey = this.lookupFactory.createKey(this.queue, key);
            Future<ReferenceValue<V>> f = (FutureTask<ReferenceValue<V>>)this.cache.get(refKey);
            V value = this.dereferenceValue(f);
            if (value != null) {
                return value;
            }
            Callable call = new Callable(){

                public ReferenceValue<V> call() throws Exception {
                    Object created = ReferenceCache.this.create(key);
                    if (created != null) {
                        return ReferenceCache.this.valueFactory.createValue(ReferenceCache.this.queue, created);
                    }
                    throw new NullPointerException("Value created was Null");
                }
            };
            FutureTask<ReferenceValue<V>> task = new FutureTask<ReferenceValue<V>>(call);
            refKey = this.keyFactory.createKey(this.queue, key);
            f = this.cache.putIfAbsent(refKey, task);
            if (f == null) {
                f = task;
                task.run();
            }
            if ((value = this.dereferenceValue(f)) == null) {
                value = this.create(key);
                this.put(key, value);
            }
            return value;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    private V dereferenceValue(ReferenceValue<V> refValue) {
        return refValue == null ? null : (V)refValue.get();
    }

    private V dereferenceValue(Future<ReferenceValue<V>> futureValue) {
        try {
            return futureValue == null ? null : (V)this.dereferenceValue(futureValue.get());
        }
        catch (Exception e) {
            return null;
        }
    }

    public V put(K key, final V value) {
        Callable call;
        FutureTask task;
        ReferenceKey<K> refKey = this.keyFactory.createKey(this.queue, key);
        FutureTask f = this.cache.putIfAbsent(refKey, task = new FutureTask(call = new Callable(){

            public ReferenceValue<V> call() throws Exception {
                return ReferenceCache.this.valueFactory.createValue(ReferenceCache.this.queue, value);
            }
        }));
        if (f == null) {
            f = task;
            task.run();
        }
        return value;
    }

    public V remove(Object key) {
        ReferenceKey<Object> keyRef = this.lookupFactory.createKey(this.queue, key);
        return this.dereferenceValue((Future)this.cache.remove(keyRef));
    }

    public int size() {
        return this.cache.size();
    }

    public void clear() {
        this.cache.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ReferenceFactory<K, V> {
        public abstract ReferenceKey<K> createKey(ReferenceQueue var1, K var2);

        public abstract ReferenceValue<V> createValue(ReferenceQueue var1, V var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ReferenceKey<K> {
        private final int hashCode;

        public ReferenceKey(K key) {
            this.hashCode = key.hashCode();
        }

        protected abstract K get();

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            K me = this.get();
            if (me != null) {
                if (obj == me) {
                    return true;
                }
                if (obj instanceof ReferenceKey) {
                    K them = ((ReferenceKey)obj).get();
                    return me == them || me.equals(them);
                }
            }
            return false;
        }

        public void remove() {
            ReferenceCache.this.cache.remove(this);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private class ReferenceQueueRunner
    extends ReferenceQueue
    implements Runnable {
        private ReferenceQueueRunner() {
        }

        public void run() {
            try {
                while (true) {
                    Reference ref;
                    if ((ref = this.remove()) == null) {
                        continue;
                    }
                    ref.clear();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ReferenceValue<V> {
        public V get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SoftReferenceFactory
    extends ReferenceFactory<K, V> {
        private SoftReferenceFactory() {
        }

        @Override
        public ReferenceValue<V> createValue(ReferenceQueue queue, V value) {
            return new ReferenceValue<V>(value, queue){
                private final SoftReference<V> ref;
                {
                    this.ref = new SoftReference<Object>(object, referenceQueue);
                }

                @Override
                public V get() {
                    return this.ref.get();
                }
            };
        }

        @Override
        public ReferenceKey<K> createKey(ReferenceQueue queue, K key) {
            return new SoftReferenceKey(queue, key);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SoftReferenceKey
        extends ReferenceKey<K> {
            private final SoftReference<K> ref;

            public SoftReferenceKey(ReferenceQueue queue, K key) {
                super(key);
                this.ref = new SoftReference<K>(key, queue){

                    @Override
                    public void clear() {
                        SoftReferenceKey.this.remove();
                        super.clear();
                    }
                };
            }

            @Override
            public K get() {
                return this.ref.get();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StrongReferenceFactory
    extends ReferenceFactory<K, V> {
        private StrongReferenceFactory() {
        }

        @Override
        public ReferenceValue<V> createValue(ReferenceQueue queue, final V value) {
            return new ReferenceValue<V>(){

                @Override
                public V get() {
                    return value;
                }
            };
        }

        @Override
        public ReferenceKey<K> createKey(ReferenceQueue queue, final K key) {
            return new ReferenceKey<K>(ReferenceCache.this, key){

                @Override
                public K get() {
                    return key;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Strong,
        Weak,
        Soft;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WeakReferenceFactory
    extends ReferenceFactory<K, V> {
        private WeakReferenceFactory() {
        }

        @Override
        public ReferenceValue<V> createValue(ReferenceQueue queue, V value) {
            return new ReferenceValue<V>(value, queue){
                private final WeakReference<V> ref;
                {
                    this.ref = new WeakReference<Object>(object, referenceQueue);
                }

                @Override
                public V get() {
                    return this.ref.get();
                }
            };
        }

        @Override
        public ReferenceKey<K> createKey(ReferenceQueue queue, K key) {
            return new WeakReferenceKey(queue, key);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class WeakReferenceKey
        extends ReferenceKey<K> {
            private final WeakReference<K> ref;

            public WeakReferenceKey(ReferenceQueue queue, K key) {
                super(key);
                this.ref = new WeakReference<K>(key, queue){

                    @Override
                    public void clear() {
                        WeakReferenceKey.this.remove();
                        super.clear();
                    }
                };
            }

            @Override
            public K get() {
                return this.ref.get();
            }
        }
    }
}

