/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.jboss.elasticsearch.river.jira.ChangedIssuesResults;
import org.jboss.elasticsearch.river.jira.IJIRAClient;
import org.jboss.elasticsearch.river.jira.IJIRAIssueIndexStructureBuilder;
import org.jboss.elasticsearch.river.jira.Utils;

public class JIRA5RestClient
implements IJIRAClient {
    private static final ESLogger logger = Loggers.getLogger(JIRA5RestClient.class);
    private HttpClient httpclient;
    protected String jiraRestAPIUrlBase;
    protected boolean isAuthConfigured = false;
    protected int listJIRAIssuesMax = -1;
    protected IJIRAIssueIndexStructureBuilder indexStructureBuilder;
    private static final String JQL_DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm";
    protected SimpleDateFormat jqlDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public JIRA5RestClient(String jiraUrlBase, String jiraUsername, String jiraPassword, Integer timeout) {
        this.jiraRestAPIUrlBase = JIRA5RestClient.prepareAPIURLFromBaseURL(jiraUrlBase);
        if (this.jiraRestAPIUrlBase == null) {
            throw new SettingsException("Parameter jira/urlBase must be set!");
        }
        URL url = null;
        try {
            url = new URL(this.jiraRestAPIUrlBase);
        }
        catch (MalformedURLException e) {
            throw new SettingsException("Parameter jira/urlBase is malformed " + e.getMessage());
        }
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setDefaultMaxConnectionsPerHost(20);
        params.setMaxTotalConnections(20);
        if (timeout != null) {
            params.setSoTimeout(timeout.intValue());
            params.setConnectionTimeout(timeout.intValue());
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.setParams(params);
        this.httpclient = new HttpClient((HttpConnectionManager)connectionManager);
        this.httpclient.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        if (jiraUsername != null && !"".equals(jiraUsername.trim())) {
            this.httpclient.getParams().setAuthenticationPreemptive(true);
            String host = url.getHost();
            this.httpclient.getState().setCredentials(new AuthScope(host, -1, null), (Credentials)new UsernamePasswordCredentials(jiraUsername, jiraPassword));
            this.isAuthConfigured = true;
        }
    }

    protected static String prepareAPIURLFromBaseURL(String baseURL) {
        if (Utils.isEmpty(baseURL)) {
            return null;
        }
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        return baseURL + "rest/api/2/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllJIRAProjects() throws Exception {
        XContentParser parser = null;
        try {
            byte[] responseData = this.performJIRAGetRESTCall("project", null);
            logger.debug("JIRA REST response data: {}", new Object[]{new String(responseData)});
            StringBuilder sb = new StringBuilder();
            sb.append("{ \"projects\" : ").append(new String(responseData, "UTF-8")).append("}");
            responseData = sb.toString().getBytes("UTF-8");
            parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(responseData);
            Map responseParsed = parser.mapAndClose();
            ArrayList<String> ret = new ArrayList<String>();
            for (Map mk : (List)responseParsed.get("projects")) {
                ret.add((String)mk.get("key"));
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    @Override
    public ChangedIssuesResults getJIRAChangedIssues(String projectKey, int startAt, Date updatedAfter, Date updatedBefore) throws Exception {
        byte[] responseData = this.performJIRAChangedIssuesREST(projectKey, startAt, updatedAfter, updatedBefore);
        logger.debug("JIRA REST response data: {}", new Object[]{new String(responseData)});
        XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(responseData);
        Map responseParsed = parser.mapAndClose();
        Integer startAtRet = Utils.nodeIntegerValue(responseParsed.get("startAt"));
        Integer maxResults = Utils.nodeIntegerValue(responseParsed.get("maxResults"));
        Integer total = Utils.nodeIntegerValue(responseParsed.get("total"));
        List issues = (List)responseParsed.get("issues");
        if (startAtRet == null || maxResults == null || total == null) {
            throw new IllegalArgumentException("Bad response structure from JIRA: startAt=" + startAtRet + " maxResults=" + maxResults + " total=" + total);
        }
        return new ChangedIssuesResults(issues, startAtRet, maxResults, total);
    }

    protected byte[] performJIRAChangedIssuesREST(String projectKey, int startAt, Date updatedAfter, Date updatedBefore) throws Exception {
        String fields;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("jql", this.prepareJIRAChangedIssuesJQL(projectKey, updatedAfter, updatedBefore)));
        if (this.listJIRAIssuesMax > 0) {
            params.add(new NameValuePair("maxResults", "" + this.listJIRAIssuesMax));
        }
        params.add(new NameValuePair("startAt", startAt + ""));
        if (this.indexStructureBuilder != null && (fields = this.indexStructureBuilder.getRequiredJIRACallIssueFields()) != null) {
            params.add(new NameValuePair("fields", this.indexStructureBuilder.getRequiredJIRACallIssueFields()));
        }
        return this.performJIRAGetRESTCall("search", params);
    }

    protected String prepareJIRAChangedIssuesJQL(String projectKey, Date updatedAfter, Date updatedBefore) {
        if (Utils.isEmpty(projectKey)) {
            throw new IllegalArgumentException("projectKey must be defined");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("project='").append(projectKey).append("'");
        if (updatedAfter != null) {
            sb.append(" and updatedDate >= \"").append(this.formatJQLDate(updatedAfter)).append("\"");
        }
        if (updatedBefore != null) {
            sb.append(" and updatedDate <= \"").append(this.formatJQLDate(updatedBefore)).append("\"");
        }
        sb.append(" ORDER BY updated ASC");
        logger.debug("JIRA JQL string: {}", new Object[]{sb.toString()});
        return sb.toString();
    }

    @Override
    public void setJQLDateFormatTimezone(TimeZone zone) {
        this.jqlDateFormat.setTimeZone(zone);
    }

    protected synchronized String formatJQLDate(Date date) {
        String ret = null;
        if (date != null) {
            ret = this.jqlDateFormat.format(date);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] performJIRAGetRESTCall(String restOperation, List<NameValuePair> params) throws Exception {
        String url = this.jiraRestAPIUrlBase + restOperation;
        logger.debug("Go to perform JIRA REST API call to the {} with parameters {}", new Object[]{url, params});
        GetMethod method = new GetMethod(url);
        method.setDoAuthentication(this.isAuthConfigured);
        method.setFollowRedirects(true);
        method.addRequestHeader("Accept", "application/json");
        if (params != null) {
            method.setQueryString(params.toArray(new NameValuePair[0]));
        }
        try {
            int statusCode = this.httpclient.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                throw new Exception("Failed JIRA REST API call. HTTP error code: " + statusCode + " Response body: " + method.getResponseBodyAsString());
            }
            byte[] byArray = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public void setIndexStructureBuilder(IJIRAIssueIndexStructureBuilder indexStructureBuilder) {
        this.indexStructureBuilder = indexStructureBuilder;
    }

    @Override
    public IJIRAIssueIndexStructureBuilder getIndexStructureBuilder() {
        return this.indexStructureBuilder;
    }

    @Override
    public void setListJIRAIssuesMax(int listJIRAIssuesMax) {
        this.listJIRAIssuesMax = listJIRAIssuesMax;
    }

    @Override
    public int getListJIRAIssuesMax() {
        return this.listJIRAIssuesMax;
    }
}

