/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira.mgm.fullupdate;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jboss.elasticsearch.river.jira.Utils;
import org.jboss.elasticsearch.river.jira.mgm.JRMgmBaseRequest;

public class FullUpdateRequest
extends JRMgmBaseRequest {
    private String projectKey;

    FullUpdateRequest() {
    }

    public FullUpdateRequest(String riverName, String projectKey) {
        super(riverName);
        this.projectKey = projectKey;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public boolean isProjectKeyRequest() {
        return !Utils.isEmpty(this.projectKey);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.projectKey = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.projectKey);
    }

    public String toString() {
        return "FullUpdateRequest [projectKey=" + this.projectKey + ", riverName=" + this.riverName + "]";
    }
}

