/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.river.AbstractRiverComponent;
import org.elasticsearch.river.River;
import org.elasticsearch.river.RiverName;
import org.elasticsearch.river.RiverSettings;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortOrder;
import org.jboss.elasticsearch.river.jira.DateTimeUtils;
import org.jboss.elasticsearch.river.jira.IESIntegration;
import org.jboss.elasticsearch.river.jira.IJIRAClient;
import org.jboss.elasticsearch.river.jira.IJIRAIssueIndexStructureBuilder;
import org.jboss.elasticsearch.river.jira.IJIRAProjectIndexerCoordinator;
import org.jboss.elasticsearch.river.jira.IJiraRiverMgm;
import org.jboss.elasticsearch.river.jira.JIRA5RestClient;
import org.jboss.elasticsearch.river.jira.JIRA5RestIssueIndexStructureBuilder;
import org.jboss.elasticsearch.river.jira.JIRAProjectIndexerCoordinator;
import org.jboss.elasticsearch.river.jira.ProjectIndexingInfo;
import org.jboss.elasticsearch.river.jira.Utils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorFactory;

public class JiraRiver
extends AbstractRiverComponent
implements River,
IESIntegration,
IJiraRiverMgm {
    protected static Map<String, IJiraRiverMgm> riverInstances = new HashMap<String, IJiraRiverMgm>();
    protected static final String PERMSTOREPROP_RIVER_STOPPED_PERMANENTLY = "river_stopped_permanently";
    protected static final long JIRA_PROJECTS_REFRESH_TIME = 1800000L;
    public static final String INDEX_ISSUE_TYPE_NAME_DEFAULT = "jira_issue";
    public static final String INDEX_ACTIVITY_TYPE_NAME_DEFAULT = "jira_river_indexupdate";
    protected Client client;
    protected IJIRAClient jiraClient;
    protected IJIRAIssueIndexStructureBuilder jiraIssueIndexStructureBuilder;
    protected int maxIndexingThreads;
    protected long indexUpdatePeriod;
    protected long indexFullUpdatePeriod = -1L;
    protected String indexName;
    protected String typeName;
    protected String jiraUrlBase = null;
    protected String activityLogIndexName;
    protected String activityLogTypeName;
    protected Thread coordinatorThread;
    protected IJIRAProjectIndexerCoordinator coordinatorInstance;
    protected volatile boolean closed = true;
    protected List<String> projectKeysExcluded = null;
    protected List<String> allIndexedProjectsKeys = null;
    protected long allIndexedProjectsKeysNextRefresh = 0L;
    protected Map<String, ProjectIndexingInfo> lastProjectIndexingInfo = new HashMap<String, ProjectIndexingInfo>();
    protected Date lastRestartDate;
    protected Date permanentStopDate;
    protected static final String STORE_FIELD_VALUE = "value";
    private static final long ES_SCROLL_KEEPALIVE = 60000L;

    @Inject
    public JiraRiver(RiverName riverName, RiverSettings settings, Client client) throws MalformedURLException {
        super(riverName, settings);
        this.client = client;
        this.configure(settings.settings());
    }

    protected void configure(Map<String, Object> settings) {
        if (!this.closed) {
            throw new IllegalStateException("Jira River must be stopped to configure it!");
        }
        String jiraUser = null;
        String jiraJqlTimezone = TimeZone.getDefault().getDisplayName();
        if (settings.containsKey("jira")) {
            Map jiraSettings = (Map)settings.get("jira");
            this.jiraUrlBase = XContentMapValues.nodeStringValue(jiraSettings.get("urlBase"), null);
            if (Utils.isEmpty(this.jiraUrlBase)) {
                throw new SettingsException("jira/urlBase element of configuration structure not found or empty");
            }
            Integer timeout = new Long(Utils.parseTimeValue(jiraSettings, "timeout", 5L, TimeUnit.SECONDS)).intValue();
            jiraUser = XContentMapValues.nodeStringValue(jiraSettings.get("username"), (String)"Anonymous access");
            this.jiraClient = new JIRA5RestClient(this.jiraUrlBase, XContentMapValues.nodeStringValue(jiraSettings.get("username"), null), XContentMapValues.nodeStringValue(jiraSettings.get("pwd"), null), timeout);
            this.jiraClient.setListJIRAIssuesMax(XContentMapValues.nodeIntegerValue(jiraSettings.get("maxIssuesPerRequest"), (int)50));
            if (jiraSettings.get("jqlTimeZone") != null) {
                TimeZone tz = TimeZone.getTimeZone(XContentMapValues.nodeStringValue(jiraSettings.get("jqlTimeZone"), null));
                jiraJqlTimezone = tz.getDisplayName();
                this.jiraClient.setJQLDateFormatTimezone(tz);
            }
            this.maxIndexingThreads = XContentMapValues.nodeIntegerValue(jiraSettings.get("maxIndexingThreads"), (int)1);
            this.indexUpdatePeriod = Utils.parseTimeValue(jiraSettings, "indexUpdatePeriod", 5L, TimeUnit.MINUTES);
            this.indexFullUpdatePeriod = Utils.parseTimeValue(jiraSettings, "indexFullUpdatePeriod", 12L, TimeUnit.HOURS);
            if (jiraSettings.containsKey("projectKeysIndexed")) {
                this.allIndexedProjectsKeys = Utils.parseCsvString(XContentMapValues.nodeStringValue(jiraSettings.get("projectKeysIndexed"), null));
                if (this.allIndexedProjectsKeys != null) {
                    this.allIndexedProjectsKeysNextRefresh = Long.MAX_VALUE;
                }
            }
            if (jiraSettings.containsKey("projectKeysExcluded")) {
                this.projectKeysExcluded = Utils.parseCsvString(XContentMapValues.nodeStringValue(jiraSettings.get("projectKeysExcluded"), null));
            }
        } else {
            throw new SettingsException("'jira' element of river configuration structure not found");
        }
        Map indexSettings = null;
        if (settings.containsKey("index")) {
            indexSettings = (Map)settings.get("index");
            this.indexName = XContentMapValues.nodeStringValue(indexSettings.get("index"), (String)this.riverName.name());
            this.typeName = XContentMapValues.nodeStringValue(indexSettings.get("type"), (String)INDEX_ISSUE_TYPE_NAME_DEFAULT);
        } else {
            this.indexName = this.riverName.name();
            this.typeName = INDEX_ISSUE_TYPE_NAME_DEFAULT;
        }
        Map activityLogSettings = null;
        if (settings.containsKey("activity_log")) {
            activityLogSettings = (Map)settings.get("activity_log");
            this.activityLogIndexName = Utils.trimToNull(XContentMapValues.nodeStringValue(activityLogSettings.get("index"), null));
            if (this.activityLogIndexName == null) {
                throw new SettingsException("'activity_log/index' element of river configuration structure must be defined with some string");
            }
            this.activityLogTypeName = Utils.trimToNull(XContentMapValues.nodeStringValue(activityLogSettings.get("type"), (String)INDEX_ACTIVITY_TYPE_NAME_DEFAULT));
        }
        this.jiraIssueIndexStructureBuilder = new JIRA5RestIssueIndexStructureBuilder(this.riverName.getName(), this.indexName, this.typeName, this.jiraUrlBase, indexSettings);
        this.preparePreprocessors(indexSettings, this.jiraIssueIndexStructureBuilder);
        this.jiraClient.setIndexStructureBuilder(this.jiraIssueIndexStructureBuilder);
        this.logger.info("Configured JIRA River '{}' for JIRA base URL [{}], jira user '{}', JQL timezone '{}'. Search index name '{}', document type for issues '{}'.", new Object[]{this.riverName.getName(), this.jiraUrlBase, jiraUser, jiraJqlTimezone, this.indexName, this.typeName});
        if (this.activityLogIndexName != null) {
            this.logger.info("Activity log for JIRA River '{}' is enabled. Search index name '{}', document type for index updates '{}'.", new Object[]{this.riverName.getName(), this.activityLogIndexName, this.activityLogTypeName});
        }
    }

    private void preparePreprocessors(Map<String, Object> indexSettings, IJIRAIssueIndexStructureBuilder indexStructureBuilder) {
        List preproclist;
        if (indexSettings != null && (preproclist = (List)indexSettings.get("preprocessors")) != null && preproclist.size() > 0) {
            for (Map ppc : preproclist) {
                try {
                    indexStructureBuilder.addIssueDataPreprocessor(StructuredContentPreprocessorFactory.createPreprocessor((Map)ppc, (Client)this.client));
                }
                catch (IllegalArgumentException e) {
                    throw new SettingsException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected JiraRiver(RiverName riverName, RiverSettings settings) {
        super(riverName, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        if (!this.closed) {
            throw new IllegalStateException("Can't start already running river");
        }
        this.logger.info("starting JIRA River", new Object[0]);
        Map<String, IJiraRiverMgm> map = riverInstances;
        synchronized (map) {
            JiraRiver.addRunningInstance(this);
        }
        this.refreshSearchIndex(this.getRiverIndexName());
        try {
            this.permanentStopDate = this.readDatetimeValue(null, PERMSTOREPROP_RIVER_STOPPED_PERMANENTLY);
            if (this.permanentStopDate != null) {
                this.logger.info("JIRA River indexing process not started because stopped permanently, you can restart it over management REST API", new Object[0]);
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logger.info("starting JIRA River indexing process", new Object[0]);
        this.closed = false;
        this.lastRestartDate = new Date();
        this.coordinatorInstance = new JIRAProjectIndexerCoordinator(this.jiraClient, this, this.jiraIssueIndexStructureBuilder, this.indexUpdatePeriod, this.maxIndexingThreads, this.indexFullUpdatePeriod);
        this.coordinatorThread = this.acquireIndexingThread("jira_river_coordinator", this.coordinatorInstance);
        this.coordinatorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        this.logger.info("closing JIRA River on this node", new Object[0]);
        this.closed = true;
        if (this.coordinatorThread != null) {
            this.coordinatorThread.interrupt();
        }
        this.coordinatorThread = null;
        this.coordinatorInstance = null;
        Map<String, IJiraRiverMgm> map = riverInstances;
        synchronized (map) {
            riverInstances.remove(this.riverName().getName());
        }
    }

    @Override
    public synchronized void stop(boolean permanent) {
        this.logger.info("stopping JIRA River indexing process", new Object[0]);
        this.closed = true;
        if (this.coordinatorThread != null) {
            this.coordinatorThread.interrupt();
        }
        this.coordinatorThread = null;
        this.coordinatorInstance = null;
        if (permanent) {
            try {
                this.permanentStopDate = new Date();
                this.storeDatetimeValue(null, PERMSTOREPROP_RIVER_STOPPED_PERMANENTLY, this.permanentStopDate, null);
                this.refreshSearchIndex(this.getRiverIndexName());
                this.logger.info("JIRA River indexing process stopped permanently, you can restart it over management REST API", new Object[0]);
            }
            catch (IOException e) {
                this.logger.warn("Permanent stopped value storing failed {}", new Object[]{e.getMessage()});
            }
        }
    }

    public synchronized void reconfigure() {
        if (!this.closed) {
            throw new IllegalStateException("Jira River must be stopped to reconfigure it!");
        }
        this.logger.info("reconfiguring JIRA River", new Object[0]);
        String riverIndexName = this.getRiverIndexName();
        this.refreshSearchIndex(riverIndexName);
        GetResponse resp = (GetResponse)this.client.prepareGet(riverIndexName, this.riverName().name(), "_meta").execute().actionGet();
        if (resp.exists()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Configuration document: {}", new Object[]{resp.getSourceAsString()});
            }
        } else {
            throw new IllegalStateException("Configuration document not found to reconfigure jira river " + this.riverName().name());
        }
        Map newset = resp.getSource();
        this.configure(newset);
    }

    @Override
    public synchronized void restart() {
        this.logger.info("restarting JIRA River", new Object[0]);
        boolean cleanPermanent = true;
        if (!this.closed) {
            cleanPermanent = false;
            this.stop(false);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                return;
            }
        } else {
            this.logger.debug("stopped already", new Object[0]);
        }
        this.reconfigure();
        if (cleanPermanent) {
            this.deleteDatetimeValue(null, PERMSTOREPROP_RIVER_STOPPED_PERMANENTLY);
        }
        this.start();
        this.logger.info("JIRA River restarted", new Object[0]);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public String forceFullReindex(String jiraProjectKey) throws Exception {
        if (this.coordinatorInstance == null) {
            return null;
        }
        List<String> pkeys = this.getAllIndexedProjectsKeys();
        if (Utils.isEmpty(jiraProjectKey)) {
            if (pkeys != null) {
                for (String k : pkeys) {
                    this.coordinatorInstance.forceFullReindex(k);
                }
                return Utils.createCsvString(pkeys);
            }
            return "";
        }
        if (pkeys != null && pkeys.contains(jiraProjectKey)) {
            this.coordinatorInstance.forceFullReindex(jiraProjectKey);
            return jiraProjectKey;
        }
        return null;
    }

    @Override
    public String getRiverOperationInfo(DiscoveryNode esNode, Date currentDate) throws Exception {
        List<String> pkeys;
        List<ProjectIndexingInfo> currProjectIndexingInfo;
        XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
        builder.startObject();
        builder.field("river_name", this.riverName().getName());
        builder.field("info_date", currentDate);
        builder.startObject("indexing");
        builder.field("state", this.closed ? "stopped" : "running");
        if (!this.closed) {
            builder.field("last_restart", this.lastRestartDate);
        } else if (this.permanentStopDate != null) {
            builder.field("stopped_permanently", this.permanentStopDate);
        }
        builder.endObject();
        if (esNode != null) {
            builder.startObject("node");
            builder.field("id", esNode.getId());
            builder.field("name", esNode.getName());
            builder.endObject();
        }
        if (this.coordinatorInstance != null && (currProjectIndexingInfo = this.coordinatorInstance.getCurrentProjectIndexingInfo()) != null) {
            builder.startArray("current_indexing");
            for (ProjectIndexingInfo pi : currProjectIndexingInfo) {
                pi.buildDocument(builder, true, false);
            }
            builder.endArray();
        }
        if ((pkeys = this.getAllIndexedProjectsKeys()) != null) {
            builder.startArray("indexed_jira_projects");
            for (String projectKey : pkeys) {
                builder.startObject();
                builder.field("project_key", projectKey);
                ProjectIndexingInfo lastIndexing = this.getLastProjectIndexingInfo(projectKey);
                if (lastIndexing != null) {
                    builder.field("last_indexing");
                    lastIndexing.buildDocument(builder, false, true);
                }
                builder.endObject();
            }
            builder.endArray();
        }
        builder.endObject();
        return builder.string();
    }

    protected ProjectIndexingInfo getLastProjectIndexingInfo(String projectKey) {
        ProjectIndexingInfo lastIndexing = this.lastProjectIndexingInfo.get(projectKey);
        if (lastIndexing == null && this.activityLogIndexName != null) {
            try {
                this.refreshSearchIndex(this.activityLogIndexName);
                SearchResponse sr = (SearchResponse)this.client.prepareSearch(new String[]{this.activityLogIndexName}).setTypes(new String[]{this.activityLogTypeName}).setFilter((FilterBuilder)FilterBuilders.termFilter((String)"project_key", (String)projectKey)).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addSort("start_date", SortOrder.DESC).addField("_source").setSize(1).execute().actionGet();
                if (sr.hits().getTotalHits() > 0L) {
                    SearchHit hit = sr.hits().getAt(0);
                    lastIndexing = ProjectIndexingInfo.readFromDocument(hit.sourceAsMap());
                } else {
                    this.logger.debug("No last indexing info found in activity log for project {}", new Object[]{projectKey});
                }
            }
            catch (Exception e) {
                this.logger.warn("Error during LastProjectIndexingInfo reading from activity log ES index: {} {}", new Object[]{e.getClass().getName(), e.getMessage()});
            }
        }
        return lastIndexing;
    }

    public static IJiraRiverMgm getRunningInstance(String riverName) {
        if (riverName == null) {
            return null;
        }
        return riverInstances.get(riverName);
    }

    public static void addRunningInstance(IJiraRiverMgm jiraRiver) {
        riverInstances.put(jiraRiver.riverName().getName(), jiraRiver);
    }

    public static Set<String> getRunningInstances() {
        return Collections.unmodifiableSet(riverInstances.keySet());
    }

    @Override
    public List<String> getAllIndexedProjectsKeys() throws Exception {
        if (this.allIndexedProjectsKeys == null || this.allIndexedProjectsKeysNextRefresh < System.currentTimeMillis()) {
            this.allIndexedProjectsKeys = this.jiraClient.getAllJIRAProjects();
            if (this.projectKeysExcluded != null) {
                this.allIndexedProjectsKeys.removeAll(this.projectKeysExcluded);
            }
            this.allIndexedProjectsKeysNextRefresh = System.currentTimeMillis() + 1800000L;
        }
        return this.allIndexedProjectsKeys;
    }

    @Override
    public void reportIndexingFinished(ProjectIndexingInfo indexingInfo) {
        this.lastProjectIndexingInfo.put(indexingInfo.projectKey, indexingInfo);
        if (this.coordinatorInstance != null) {
            try {
                this.coordinatorInstance.reportIndexingFinished(indexingInfo.projectKey, indexingInfo.finishedOK, indexingInfo.fullUpdate);
            }
            catch (Exception e) {
                this.logger.warn("Indexing finished reporting to coordinator failed due {}", new Object[]{e.getMessage()});
            }
        }
        this.writeActivityLogRecord(indexingInfo);
    }

    protected void writeActivityLogRecord(ProjectIndexingInfo indexingInfo) {
        if (this.activityLogIndexName != null) {
            try {
                this.client.prepareIndex(this.activityLogIndexName, this.activityLogTypeName).setSource(indexingInfo.buildDocument(XContentFactory.jsonBuilder(), true, true)).execute().actionGet();
            }
            catch (Exception e) {
                this.logger.error("Error during index update result writing to the audit log {}", new Object[]{e.getMessage()});
            }
        }
    }

    @Override
    public void storeDatetimeValue(String projectKey, String propertyName, Date datetime, BulkRequestBuilder esBulk) throws IOException {
        String documentName = JiraRiver.prepareValueStoreDocumentName(projectKey, propertyName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Going to write {} property with datetime value {} for project {} using {} update. Document name is {}.", new Object[]{propertyName, datetime, projectKey, esBulk != null ? "bulk" : "direct", documentName});
        }
        if (esBulk != null) {
            esBulk.add(Requests.indexRequest((String)this.getRiverIndexName()).type(this.riverName.name()).id(documentName).source(this.storeDatetimeValueBuildDocument(projectKey, propertyName, datetime)));
        } else {
            this.client.prepareIndex(this.getRiverIndexName(), this.riverName.name(), documentName).setSource(this.storeDatetimeValueBuildDocument(projectKey, propertyName, datetime)).execute().actionGet();
        }
    }

    protected XContentBuilder storeDatetimeValueBuildDocument(String projectKey, String propertyName, Date datetime) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        if (projectKey != null) {
            builder.field("projectKey", projectKey);
        }
        builder.field("propertyName", propertyName).field(STORE_FIELD_VALUE, DateTimeUtils.formatISODateTime(datetime));
        builder.endObject();
        return builder;
    }

    @Override
    public Date readDatetimeValue(String projectKey, String propertyName) throws IOException {
        Date lastDate = null;
        String documentName = JiraRiver.prepareValueStoreDocumentName(projectKey, propertyName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Going to read datetime value from {} property for project {}. Document name is {}.", new Object[]{propertyName, projectKey, documentName});
        }
        this.refreshSearchIndex(this.getRiverIndexName());
        GetResponse lastSeqGetResponse = (GetResponse)this.client.prepareGet(this.getRiverIndexName(), this.riverName.name(), documentName).execute().actionGet();
        if (lastSeqGetResponse.exists()) {
            Object timestamp = lastSeqGetResponse.sourceAsMap().get(STORE_FIELD_VALUE);
            if (timestamp != null) {
                lastDate = DateTimeUtils.parseISODateTime(timestamp.toString());
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} document doesn't exist in JIRA river persistent store", new Object[]{documentName});
        }
        return lastDate;
    }

    @Override
    public boolean deleteDatetimeValue(String projectKey, String propertyName) {
        String documentName = JiraRiver.prepareValueStoreDocumentName(projectKey, propertyName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Going to delete datetime value from {} property for project {}. Document name is {}.", new Object[]{propertyName, projectKey, documentName});
        }
        this.refreshSearchIndex(this.getRiverIndexName());
        DeleteResponse lastSeqGetResponse = (DeleteResponse)this.client.prepareDelete(this.getRiverIndexName(), this.riverName.name(), documentName).execute().actionGet();
        if (lastSeqGetResponse.notFound()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} document doesn't exist in JIRA river persistent store", new Object[]{documentName});
            }
            return false;
        }
        return true;
    }

    protected String getRiverIndexName() {
        return "_river";
    }

    protected static String prepareValueStoreDocumentName(String projectKey, String propertyName) {
        if (projectKey != null) {
            return "_" + propertyName + "_" + projectKey;
        }
        return "_" + propertyName;
    }

    @Override
    public BulkRequestBuilder prepareESBulkRequestBuilder() {
        return this.client.prepareBulk();
    }

    @Override
    public void executeESBulkRequest(BulkRequestBuilder esBulk) throws Exception {
        BulkResponse response = (BulkResponse)esBulk.execute().actionGet();
        if (response.hasFailures()) {
            throw new ElasticSearchException("Failed to execute ES index bulk update: " + response.buildFailureMessage());
        }
    }

    @Override
    public Thread acquireIndexingThread(String threadName, Runnable runnable) {
        return EsExecutors.daemonThreadFactory((Settings)this.settings.globalSettings(), (String)threadName).newThread(runnable);
    }

    @Override
    public void refreshSearchIndex(String indexName) {
        this.client.admin().indices().prepareRefresh(new String[]{indexName}).execute().actionGet();
    }

    @Override
    public SearchRequestBuilder prepareESScrollSearchRequestBuilder(String indexName) {
        return this.client.prepareSearch(new String[]{indexName}).setScroll(new TimeValue(60000L)).setSearchType(SearchType.SCAN).setSize(100);
    }

    @Override
    public SearchResponse executeESSearchRequest(SearchRequestBuilder searchRequestBuilder) {
        return (SearchResponse)searchRequestBuilder.execute().actionGet();
    }

    @Override
    public SearchResponse executeESScrollSearchNextRequest(SearchResponse scrollResp) {
        return (SearchResponse)this.client.prepareSearchScroll(scrollResp.getScrollId()).setScroll(new TimeValue(60000L)).execute().actionGet();
    }
}

