/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.query.BoolFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeFilterBuilder;
import org.elasticsearch.index.query.TermFilterBuilder;
import org.elasticsearch.search.SearchHit;
import org.jboss.elasticsearch.river.jira.DateTimeUtils;
import org.jboss.elasticsearch.river.jira.IJIRAIssueIndexStructureBuilder;
import org.jboss.elasticsearch.river.jira.IssueCommentIndexingMode;
import org.jboss.elasticsearch.river.jira.Utils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessor;

public class JIRA5RestIssueIndexStructureBuilder
implements IJIRAIssueIndexStructureBuilder {
    private static final ESLogger logger = Loggers.getLogger(JIRA5RestIssueIndexStructureBuilder.class);
    public static final String JF_KEY = "key";
    public static final String JF_ID = "id";
    public static final String JF_UPDATED = "fields.updated";
    public static final String JF_COMMENT = "fields.comment";
    public static final String JF_COMMENTS = "fields.comment.comments";
    public static final String JF_CHANGELOG = "changelog";
    public static final String JF_CHANGELOG_ARRAY = "changelog.histories";
    protected String riverName;
    protected String indexName;
    protected String issueTypeName;
    protected static final String CONFIG_FIELDS = "fields";
    protected static final String CONFIG_FIELDS_JIRAFIELD = "jira_field";
    protected static final String CONFIG_FIELDS_VALUEFILTER = "value_filter";
    protected static final String CONFIG_FILTERS = "value_filters";
    protected static final String CONFIG_JIRAFIELD_ISSUEDOCUMENTID = "jira_field_issue_document_id";
    protected static final String CONFIG_FIELDRIVERNAME = "field_river_name";
    protected static final String CONFIG_FIELDPROJECTKEY = "field_project_key";
    protected static final String CONFIG_FIELDISSUEKEY = "field_issue_key";
    protected static final String CONFIG_FIELDJIRAURL = "field_jira_url";
    protected static final String CONFIG_COMMENTMODE = "comment_mode";
    protected static final String CONFIG_FIELDCOMMENTS = "field_comments";
    protected static final String CONFIG_COMMENTTYPE = "comment_type";
    protected static final String CONFIG_COMMENTFILEDS = "comment_fields";
    protected static final String CONFIG_CHANGELOGMODE = "changelog_mode";
    protected static final String CONFIG_FIELDCHANGELOGS = "field_changelogs";
    protected static final String CONFIG_CHANGELOGTYPE = "changelog_type";
    protected static final String CONFIG_CHANGELOGFILEDS = "changelog_fields";
    protected String jiraFieldForIssueDocumentId = null;
    protected Map<String, Map<String, String>> fieldsConfig;
    protected Map<String, Map<String, String>> filtersConfig;
    protected String indexFieldForRiverName = null;
    protected String indexFieldForProjectKey = null;
    protected String indexFieldForIssueKey = null;
    protected String indexFieldForJiraURL = null;
    protected Set<String> jiraCallFieldSet = new LinkedHashSet<String>();
    protected Set<String> jiraCallExpandSet = new LinkedHashSet<String>();
    protected String jiraIssueShowUrlBase;
    protected IssueCommentIndexingMode commentIndexingMode;
    protected String indexFieldForComments = null;
    protected String commentTypeName;
    protected Map<String, Map<String, String>> commentFieldsConfig;
    protected IssueCommentIndexingMode changelogIndexingMode;
    protected String indexFieldForChangelogs = null;
    protected String changelogTypeName;
    protected Map<String, Map<String, String>> changelogFieldsConfig;
    protected List<StructuredContentPreprocessor> issueDataPreprocessors = null;

    protected JIRA5RestIssueIndexStructureBuilder() {
    }

    public JIRA5RestIssueIndexStructureBuilder(String riverName, String indexName, String issueTypeName, String jiraUrlBase, Map<String, Object> settings) throws SettingsException {
        this.riverName = riverName;
        this.indexName = indexName;
        this.issueTypeName = issueTypeName;
        this.constructJIRAIssueShowUrlBase(jiraUrlBase);
        if (settings != null) {
            this.jiraFieldForIssueDocumentId = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_JIRAFIELD_ISSUEDOCUMENTID), null));
            this.indexFieldForRiverName = XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_FIELDRIVERNAME), null);
            this.indexFieldForProjectKey = XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_FIELDPROJECTKEY), null);
            this.indexFieldForIssueKey = XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_FIELDISSUEKEY), null);
            this.indexFieldForJiraURL = XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_FIELDJIRAURL), null);
            this.filtersConfig = (Map)settings.get(CONFIG_FILTERS);
            this.fieldsConfig = (Map)settings.get(CONFIG_FIELDS);
            this.commentIndexingMode = IssueCommentIndexingMode.parseConfiguration(XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_COMMENTMODE), null), IssueCommentIndexingMode.EMBEDDED);
            this.indexFieldForComments = XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_FIELDCOMMENTS), null);
            this.commentTypeName = XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_COMMENTTYPE), null);
            this.commentFieldsConfig = (Map)settings.get(CONFIG_COMMENTFILEDS);
            this.changelogIndexingMode = IssueCommentIndexingMode.parseConfiguration(XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_CHANGELOGMODE), null), IssueCommentIndexingMode.NONE);
            this.indexFieldForChangelogs = XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_FIELDCHANGELOGS), null);
            this.changelogTypeName = XContentMapValues.nodeStringValue((Object)settings.get(CONFIG_CHANGELOGTYPE), null);
            this.changelogFieldsConfig = (Map)settings.get(CONFIG_CHANGELOGFILEDS);
        }
        this.loadDefaultsIfNecessary();
        this.validateConfiguration();
        this.prepareJiraCallFieldSet();
    }

    private void loadDefaultsIfNecessary() {
        Map<String, Object> settingsDefault = this.loadDefaultSettingsMapFromFile();
        this.filtersConfig = this.loadDefaultMapIfNecessary(this.filtersConfig, CONFIG_FILTERS, settingsDefault);
        this.fieldsConfig = this.loadDefaultMapIfNecessary(this.fieldsConfig, CONFIG_FIELDS, settingsDefault);
        this.indexFieldForRiverName = this.loadDefaultStringIfNecessary(this.indexFieldForRiverName, CONFIG_FIELDRIVERNAME, settingsDefault);
        this.indexFieldForProjectKey = this.loadDefaultStringIfNecessary(this.indexFieldForProjectKey, CONFIG_FIELDPROJECTKEY, settingsDefault);
        this.indexFieldForIssueKey = this.loadDefaultStringIfNecessary(this.indexFieldForIssueKey, CONFIG_FIELDISSUEKEY, settingsDefault);
        this.indexFieldForJiraURL = this.loadDefaultStringIfNecessary(this.indexFieldForJiraURL, CONFIG_FIELDJIRAURL, settingsDefault);
        if (this.commentIndexingMode == null) {
            this.commentIndexingMode = IssueCommentIndexingMode.parseConfiguration(XContentMapValues.nodeStringValue((Object)settingsDefault.get(CONFIG_COMMENTMODE), null), IssueCommentIndexingMode.EMBEDDED);
        }
        this.indexFieldForComments = this.loadDefaultStringIfNecessary(this.indexFieldForComments, CONFIG_FIELDCOMMENTS, settingsDefault);
        this.commentTypeName = this.loadDefaultStringIfNecessary(this.commentTypeName, CONFIG_COMMENTTYPE, settingsDefault);
        this.commentFieldsConfig = this.loadDefaultMapIfNecessary(this.commentFieldsConfig, CONFIG_COMMENTFILEDS, settingsDefault);
        if (this.changelogIndexingMode == null) {
            this.changelogIndexingMode = IssueCommentIndexingMode.parseConfiguration(XContentMapValues.nodeStringValue((Object)settingsDefault.get(CONFIG_CHANGELOGMODE), null), IssueCommentIndexingMode.NONE);
        }
        this.indexFieldForChangelogs = this.loadDefaultStringIfNecessary(this.indexFieldForChangelogs, CONFIG_FIELDCHANGELOGS, settingsDefault);
        this.changelogTypeName = this.loadDefaultStringIfNecessary(this.changelogTypeName, CONFIG_CHANGELOGTYPE, settingsDefault);
        this.changelogFieldsConfig = this.loadDefaultMapIfNecessary(this.changelogFieldsConfig, CONFIG_CHANGELOGFILEDS, settingsDefault);
    }

    private void validateConfiguration() {
        this.validateConfigurationObject(this.filtersConfig, "index/value_filters");
        this.validateConfigurationObject(this.fieldsConfig, "index/fields");
        this.validateConfigurationString(this.indexFieldForRiverName, "index/field_river_name");
        this.validateConfigurationString(this.indexFieldForProjectKey, "index/field_project_key");
        this.validateConfigurationString(this.indexFieldForIssueKey, "index/field_issue_key");
        this.validateConfigurationString(this.indexFieldForJiraURL, "index/field_jira_url");
        this.validateConfigurationObject((Object)this.commentIndexingMode, "index/comment_mode");
        this.validateConfigurationObject(this.commentFieldsConfig, "index/comment_fields");
        this.validateConfigurationString(this.commentTypeName, "index/comment_type");
        this.validateConfigurationString(this.indexFieldForComments, "index/field_comments");
        this.validateConfigurationObject((Object)this.changelogIndexingMode, "index/changelog_mode");
        this.validateConfigurationObject(this.changelogFieldsConfig, "index/changelog_fields");
        this.validateConfigurationString(this.changelogTypeName, "index/changelog_type");
        this.validateConfigurationString(this.indexFieldForChangelogs, "index/field_changelogs");
        this.validateConfigurationFieldsStructure(this.fieldsConfig, "index/fields");
        this.validateConfigurationFieldsStructure(this.commentFieldsConfig, "index/comment_fields");
    }

    protected void prepareJiraCallFieldSet() {
        this.jiraCallFieldSet.clear();
        this.jiraCallExpandSet.clear();
        this.jiraCallFieldSet.add(JIRA5RestIssueIndexStructureBuilder.getJiraCallFieldName(JF_UPDATED));
        for (Map<String, String> fc : this.fieldsConfig.values()) {
            String jf = JIRA5RestIssueIndexStructureBuilder.getJiraCallFieldName(fc.get(CONFIG_FIELDS_JIRAFIELD));
            if (jf == null) continue;
            this.jiraCallFieldSet.add(jf);
        }
        if (this.commentIndexingMode != null && this.commentIndexingMode != IssueCommentIndexingMode.NONE) {
            this.jiraCallFieldSet.add(JIRA5RestIssueIndexStructureBuilder.getJiraCallFieldName(JF_COMMENT));
        }
        if (this.changelogIndexingMode != null && this.changelogIndexingMode != IssueCommentIndexingMode.NONE) {
            this.jiraCallExpandSet.add(JF_CHANGELOG);
        }
    }

    @Override
    public void addIssueDataPreprocessor(StructuredContentPreprocessor preprocessor) {
        if (preprocessor == null) {
            return;
        }
        if (this.issueDataPreprocessors == null) {
            this.issueDataPreprocessors = new ArrayList<StructuredContentPreprocessor>();
        }
        this.issueDataPreprocessors.add(preprocessor);
    }

    @Override
    public String getIssuesSearchIndexName(String jiraProjectKey) {
        return this.indexName;
    }

    @Override
    public String getRequiredJIRACallIssueFields() {
        return Utils.createCsvString(this.jiraCallFieldSet);
    }

    @Override
    public String getRequiredJIRACallIssueExpands() {
        return Utils.createCsvString(this.jiraCallExpandSet);
    }

    @Override
    public void indexIssue(BulkRequestBuilder esBulk, String jiraProjectKey, Map<String, Object> issue) throws Exception {
        List<Map<String, Object>> changelogs;
        IndexRequest irq;
        String commentId;
        String issueKey;
        List<Map<String, Object>> comments;
        issue = this.preprocessIssueData(jiraProjectKey, issue);
        esBulk.add(Requests.indexRequest((String)this.indexName).type(this.issueTypeName).id(this.prepareIssueDocumentId(issue)).source(this.prepareIssueIndexedDocument(jiraProjectKey, issue)));
        if (this.commentIndexingMode.isExtraDocumentIndexed() && (comments = this.extractIssueComments(issue)) != null && !comments.isEmpty()) {
            issueKey = this.extractIssueKey(issue);
            for (Map<String, Object> comment : comments) {
                commentId = this.extractCommentId(comment);
                irq = Requests.indexRequest((String)this.indexName).type(this.commentTypeName).id(commentId).source(this.prepareCommentIndexedDocument(jiraProjectKey, issueKey, comment));
                if (this.commentIndexingMode == IssueCommentIndexingMode.CHILD) {
                    irq.parent(issueKey);
                }
                esBulk.add(irq);
            }
        }
        if (this.changelogIndexingMode.isExtraDocumentIndexed() && (changelogs = this.extractIssueChangelogs(issue)) != null && !changelogs.isEmpty()) {
            issueKey = this.extractIssueKey(issue);
            for (Map<String, Object> changelog : changelogs) {
                commentId = this.extractChangelogId(changelog);
                irq = Requests.indexRequest((String)this.indexName).type(this.changelogTypeName).id(commentId).source(this.prepareChangelogIndexedDocument(jiraProjectKey, issueKey, changelog));
                if (this.changelogIndexingMode == IssueCommentIndexingMode.CHILD) {
                    irq.parent(issueKey);
                }
                esBulk.add(irq);
            }
        }
    }

    protected String prepareIssueDocumentId(Map<String, Object> issue) {
        String documentId = null;
        if (this.jiraFieldForIssueDocumentId != null) {
            documentId = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)XContentMapValues.extractValue((String)this.jiraFieldForIssueDocumentId, issue), null));
        }
        if (documentId == null) {
            documentId = this.extractIssueKey(issue);
        }
        return documentId;
    }

    @Override
    public String extractIssueKey(Map<String, Object> issue) {
        return XContentMapValues.nodeStringValue((Object)issue.get(JF_KEY), null);
    }

    @Override
    public Date extractIssueUpdated(Map<String, Object> issue) {
        return DateTimeUtils.parseISODateTime(XContentMapValues.nodeStringValue((Object)XContentMapValues.extractValue((String)JF_UPDATED, issue), null));
    }

    public String extractCommentId(Map<String, Object> comment) {
        return XContentMapValues.nodeStringValue((Object)comment.get(JF_ID), null);
    }

    public String extractChangelogId(Map<String, Object> changelog) {
        return XContentMapValues.nodeStringValue((Object)changelog.get(JF_ID), null);
    }

    protected Map<String, Object> preprocessIssueData(String jiraProjectKey, Map<String, Object> issue) {
        if (this.issueDataPreprocessors != null) {
            for (StructuredContentPreprocessor prepr : this.issueDataPreprocessors) {
                issue = prepr.preprocessData(issue);
            }
        }
        return issue;
    }

    @Override
    public void buildSearchForIndexedDocumentsNotUpdatedAfter(SearchRequestBuilder srb, String jiraProjectKey, Date date) {
        RangeFilterBuilder filterTime = FilterBuilders.rangeFilter((String)"_timestamp").lt((Object)date);
        TermFilterBuilder filterProject = FilterBuilders.termFilter((String)this.indexFieldForProjectKey, (String)jiraProjectKey);
        TermFilterBuilder filterSource = FilterBuilders.termFilter((String)this.indexFieldForRiverName, (String)this.riverName);
        BoolFilterBuilder filter = FilterBuilders.boolFilter().must((FilterBuilder)filterTime).must((FilterBuilder)filterProject).must((FilterBuilder)filterSource);
        srb.setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addField("_id").setFilter((FilterBuilder)filter);
        LinkedHashSet<String> st = new LinkedHashSet<String>();
        st.add(this.issueTypeName);
        if (this.commentIndexingMode.isExtraDocumentIndexed()) {
            st.add(this.commentTypeName);
        }
        if (this.changelogIndexingMode.isExtraDocumentIndexed()) {
            st.add(this.changelogTypeName);
        }
        srb.setTypes(st.toArray(new String[st.size()]));
    }

    @Override
    public boolean deleteIssueDocument(BulkRequestBuilder esBulk, SearchHit documentToDelete) throws Exception {
        esBulk.add(Requests.deleteRequest((String)this.indexName).type(documentToDelete.getType()).id(documentToDelete.getId()));
        return this.issueTypeName.equals(documentToDelete.getType());
    }

    protected XContentBuilder prepareIssueIndexedDocument(String jiraProjectKey, Map<String, Object> issue) throws Exception {
        List<Map<String, Object>> changelogs;
        List<Map<String, Object>> comments;
        String issueKey = this.extractIssueKey(issue);
        XContentBuilder out = XContentFactory.jsonBuilder().startObject();
        this.addValueToTheIndexField(out, this.indexFieldForRiverName, this.riverName);
        this.addValueToTheIndexField(out, this.indexFieldForProjectKey, jiraProjectKey);
        this.addValueToTheIndexField(out, this.indexFieldForIssueKey, issueKey);
        this.addValueToTheIndexField(out, this.indexFieldForJiraURL, this.prepareJIRAGUIUrl(issueKey, null));
        for (String indexFieldName : this.fieldsConfig.keySet()) {
            Map<String, String> fieldConfig = this.fieldsConfig.get(indexFieldName);
            this.addValueToTheIndex(out, indexFieldName, fieldConfig.get(CONFIG_FIELDS_JIRAFIELD), issue, fieldConfig.get(CONFIG_FIELDS_VALUEFILTER));
        }
        if (this.commentIndexingMode == IssueCommentIndexingMode.EMBEDDED && (comments = this.extractIssueComments(issue)) != null && !comments.isEmpty()) {
            out.startArray(this.indexFieldForComments);
            for (Map<String, Object> comment : comments) {
                out.startObject();
                this.addCommonFieldsToCommentIndexedDocument(out, issueKey, comment);
                out.endObject();
            }
            out.endArray();
        }
        if (this.changelogIndexingMode == IssueCommentIndexingMode.EMBEDDED && (changelogs = this.extractIssueChangelogs(issue)) != null && !changelogs.isEmpty()) {
            out.startArray(this.indexFieldForChangelogs);
            for (Map<String, Object> changelog : changelogs) {
                out.startObject();
                this.addCommonFieldsToChangelogIndexedDocument(out, issueKey, changelog);
                out.endObject();
            }
            out.endArray();
        }
        return out.endObject();
    }

    protected XContentBuilder prepareCommentIndexedDocument(String projectKey, String issueKey, Map<String, Object> comment) throws Exception {
        XContentBuilder out = XContentFactory.jsonBuilder().startObject();
        this.addValueToTheIndexField(out, this.indexFieldForRiverName, this.riverName);
        this.addValueToTheIndexField(out, this.indexFieldForProjectKey, projectKey);
        this.addValueToTheIndexField(out, this.indexFieldForIssueKey, issueKey);
        this.addCommonFieldsToCommentIndexedDocument(out, issueKey, comment);
        return out.endObject();
    }

    private void addCommonFieldsToCommentIndexedDocument(XContentBuilder out, String issueKey, Map<String, Object> comment) throws Exception {
        this.addValueToTheIndexField(out, this.indexFieldForJiraURL, this.prepareJIRAGUIUrl(issueKey, this.extractCommentId(comment)));
        for (String indexFieldName : this.commentFieldsConfig.keySet()) {
            Map<String, String> commentFieldConfig = this.commentFieldsConfig.get(indexFieldName);
            this.addValueToTheIndex(out, indexFieldName, commentFieldConfig.get(CONFIG_FIELDS_JIRAFIELD), comment, commentFieldConfig.get(CONFIG_FIELDS_VALUEFILTER));
        }
    }

    protected List<Map<String, Object>> extractIssueComments(Map<String, Object> issue) {
        List comments = (List)XContentMapValues.extractValue((String)JF_COMMENTS, issue);
        return comments;
    }

    protected XContentBuilder prepareChangelogIndexedDocument(String projectKey, String issueKey, Map<String, Object> changelog) throws Exception {
        XContentBuilder out = XContentFactory.jsonBuilder().startObject();
        this.addValueToTheIndexField(out, this.indexFieldForRiverName, this.riverName);
        this.addValueToTheIndexField(out, this.indexFieldForProjectKey, projectKey);
        this.addValueToTheIndexField(out, this.indexFieldForIssueKey, issueKey);
        this.addCommonFieldsToChangelogIndexedDocument(out, issueKey, changelog);
        return out.endObject();
    }

    private void addCommonFieldsToChangelogIndexedDocument(XContentBuilder out, String issueKey, Map<String, Object> changelog) throws Exception {
        this.addValueToTheIndexField(out, this.indexFieldForJiraURL, this.prepareJIRAGUIUrl(issueKey, null));
        for (String indexFieldName : this.changelogFieldsConfig.keySet()) {
            Map<String, String> changelogFieldConfig = this.changelogFieldsConfig.get(indexFieldName);
            this.addValueToTheIndex(out, indexFieldName, changelogFieldConfig.get(CONFIG_FIELDS_JIRAFIELD), changelog, changelogFieldConfig.get(CONFIG_FIELDS_VALUEFILTER));
        }
    }

    protected List<Map<String, Object>> extractIssueChangelogs(Map<String, Object> issue) {
        List changelogs = (List)XContentMapValues.extractValue((String)JF_CHANGELOG_ARRAY, issue);
        return changelogs;
    }

    public String prepareJIRAGUIUrl(String issueKey, String commentId) {
        if (commentId == null) {
            return this.jiraIssueShowUrlBase + issueKey;
        }
        return this.jiraIssueShowUrlBase + issueKey + "?focusedCommentId=" + commentId + "&page=com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel#comment-" + commentId;
    }

    protected void addValueToTheIndex(XContentBuilder out, String indexField, String valuePath, Map<String, Object> values, String valueFieldFilterName) throws Exception {
        Map<String, String> filter = null;
        if (!Utils.isEmpty(valueFieldFilterName)) {
            filter = this.filtersConfig.get(valueFieldFilterName);
        }
        this.addValueToTheIndex(out, indexField, valuePath, values, filter);
    }

    protected void addValueToTheIndex(XContentBuilder out, String indexField, String valuePath, Map<String, Object> values, Map<String, String> valueFieldFilter) throws Exception {
        if (values == null) {
            return;
        }
        Object v = null;
        v = valuePath.contains(".") ? XContentMapValues.extractValue((String)valuePath, values) : values.get(valuePath);
        if (v != null && valueFieldFilter != null && !valueFieldFilter.isEmpty()) {
            if (v instanceof Map) {
                Utils.remapDataInMap((Map)v, valueFieldFilter);
            } else if (v instanceof List) {
                for (Object o : (List)v) {
                    if (o instanceof Map) {
                        Utils.remapDataInMap((Map)o, valueFieldFilter);
                        continue;
                    }
                    logger.warn("Filter defined for field which is not filterable - jira array field '{}' with value: {}", new Object[]{valuePath, v});
                }
            } else {
                logger.warn("Filter defined for field which is not filterable - jira field '{}' with value: {}", new Object[]{valuePath, v});
            }
        }
        this.addValueToTheIndexField(out, indexField, v);
    }

    protected void addValueToTheIndexField(XContentBuilder out, String indexField, Object value) throws Exception {
        if (value != null) {
            out.field(indexField, value);
        }
    }

    protected static String getJiraCallFieldName(String fullJiraFieldName) {
        if (Utils.isEmpty(fullJiraFieldName)) {
            return null;
        }
        if ((fullJiraFieldName = fullJiraFieldName.trim()).startsWith("fields.")) {
            String jcrf = fullJiraFieldName.substring("fields.".length());
            if (Utils.isEmpty(jcrf)) {
                logger.warn("Bad format of jira field name '{}', nothing will be in search index", new Object[]{fullJiraFieldName});
                return null;
            }
            if (jcrf.contains(".")) {
                jcrf = jcrf.substring(0, jcrf.indexOf("."));
            }
            if (Utils.isEmpty(jcrf)) {
                logger.warn("Bad format of jira field name '{}', nothing will be in search index", new Object[]{fullJiraFieldName});
                return null;
            }
            return jcrf.trim();
        }
        return null;
    }

    protected void constructJIRAIssueShowUrlBase(String jiraUrlBase) {
        this.jiraIssueShowUrlBase = jiraUrlBase;
        if (!this.jiraIssueShowUrlBase.endsWith("/")) {
            this.jiraIssueShowUrlBase = this.jiraIssueShowUrlBase + "/";
        }
        this.jiraIssueShowUrlBase = this.jiraIssueShowUrlBase + "browse/";
    }

    private Map<String, Object> loadDefaultSettingsMapFromFile() throws SettingsException {
        Map<String, Object> json = Utils.loadJSONFromJarPackagedFile("/templates/river_configuration_default.json");
        return (Map)json.get("index");
    }

    private String loadDefaultStringIfNecessary(String valueToCheck, String valueConfigKey, Map<String, Object> settingsDefault) {
        if (Utils.isEmpty(valueToCheck)) {
            return XContentMapValues.nodeStringValue((Object)settingsDefault.get(valueConfigKey), null);
        }
        return valueToCheck.trim();
    }

    private Map<String, Map<String, String>> loadDefaultMapIfNecessary(Map<String, Map<String, String>> valueToCheck, String valueConfigKey, Map<String, Object> settingsDefault) {
        if (valueToCheck == null || valueToCheck.isEmpty()) {
            valueToCheck = (Map)settingsDefault.get(valueConfigKey);
        }
        return valueToCheck;
    }

    private void validateConfigurationFieldsStructure(Map<String, Map<String, String>> value, String configFieldName) {
        for (String idxFieldName : value.keySet()) {
            if (Utils.isEmpty(idxFieldName)) {
                throw new SettingsException("Empty key found in '" + configFieldName + "' map.");
            }
            Map<String, String> fc = value.get(idxFieldName);
            if (Utils.isEmpty(fc.get(CONFIG_FIELDS_JIRAFIELD))) {
                throw new SettingsException("'jira_field' is not defined in '" + configFieldName + "/" + idxFieldName + "'");
            }
            String fil = fc.get(CONFIG_FIELDS_VALUEFILTER);
            if (fil == null || this.filtersConfig.containsKey(fil)) continue;
            throw new SettingsException("Filter definition not found for filter name '" + fil + "' defined in '" + configFieldName + "/" + idxFieldName + "/value_filter'");
        }
    }

    private void validateConfigurationString(String value, String configFieldName) throws SettingsException {
        if (Utils.isEmpty(value)) {
            throw new SettingsException("No default '" + configFieldName + "' configuration found!");
        }
    }

    private void validateConfigurationObject(Object value, String configFieldName) throws SettingsException {
        if (value == null) {
            throw new SettingsException("No default '" + configFieldName + "' configuration found!");
        }
    }
}

