/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.jboss.elasticsearch.river.jira.ChangedIssuesResults;
import org.jboss.elasticsearch.river.jira.IJIRAClient;
import org.jboss.elasticsearch.river.jira.IJIRAIssueIndexStructureBuilder;
import org.jboss.elasticsearch.river.jira.Utils;

public class JIRA5RestClient
implements IJIRAClient {
    private static final ESLogger logger = Loggers.getLogger(JIRA5RestClient.class);
    private DefaultHttpClient httpclient;
    protected String jiraRestAPIUrlBase;
    protected boolean isAuthConfigured = false;
    protected int listJIRAIssuesMax = -1;
    protected IJIRAIssueIndexStructureBuilder indexStructureBuilder;
    private static final String JQL_DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm";
    protected SimpleDateFormat jqlDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public JIRA5RestClient(String jiraUrlBase, String jiraUsername, String jiraPassword, Integer timeout, String restApiVersion) {
        this.jiraRestAPIUrlBase = JIRA5RestClient.prepareAPIURLFromBaseURL(jiraUrlBase, restApiVersion);
        if (this.jiraRestAPIUrlBase == null) {
            throw new SettingsException("Parameter jira/urlBase must be set!");
        }
        URL url = null;
        try {
            url = new URL(this.jiraRestAPIUrlBase);
        }
        catch (MalformedURLException e) {
            throw new SettingsException("Parameter jira/urlBase is malformed " + e.getMessage());
        }
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(20);
        connectionManager.setMaxTotal(20);
        this.httpclient = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        HttpParams params = this.httpclient.getParams();
        params.setParameter("http.protocol.content-charset", (Object)"UTF-8");
        if (timeout != null) {
            params.setParameter("http.socket.timeout", (Object)timeout);
            params.setParameter("http.connection.timeout", (Object)timeout);
        }
        if (jiraUsername != null && !"".equals(jiraUsername.trim())) {
            String host = url.getHost();
            this.httpclient.getCredentialsProvider().setCredentials(new AuthScope(host, -1), (Credentials)new UsernamePasswordCredentials(jiraUsername, jiraPassword));
            this.isAuthConfigured = true;
        }
    }

    protected static String prepareAPIURLFromBaseURL(String baseURL, String restApiVersion) {
        if (Utils.isEmpty(baseURL)) {
            return null;
        }
        if ((restApiVersion = Utils.trimToNull(restApiVersion)) == null) {
            restApiVersion = "2";
        }
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        return baseURL + "rest/api/" + restApiVersion + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllJIRAProjects() throws Exception {
        try (XContentParser parser = null;){
            byte[] responseData = this.performJIRAGetRESTCall("project", null);
            logger.debug("JIRA REST response data: {}", new Object[]{new String(responseData)});
            StringBuilder sb = new StringBuilder();
            sb.append("{ \"projects\" : ").append(new String(responseData, "UTF-8")).append("}");
            responseData = sb.toString().getBytes("UTF-8");
            parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(responseData);
            Map responseParsed = parser.mapAndClose();
            ArrayList<String> ret = new ArrayList<String>();
            for (Map mk : (List)responseParsed.get("projects")) {
                ret.add((String)mk.get("key"));
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
    }

    @Override
    public ChangedIssuesResults getJIRAChangedIssues(String projectKey, int startAt, Date updatedAfter, Date updatedBefore) throws Exception {
        byte[] responseData = this.performJIRAChangedIssuesREST(projectKey, startAt, updatedAfter, updatedBefore);
        logger.debug("JIRA REST response data: {}", new Object[]{new String(responseData)});
        XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(responseData);
        Map responseParsed = parser.mapAndClose();
        Integer startAtRet = Utils.nodeIntegerValue(responseParsed.get("startAt"));
        Integer maxResults = Utils.nodeIntegerValue(responseParsed.get("maxResults"));
        Integer total = Utils.nodeIntegerValue(responseParsed.get("total"));
        List issues = (List)responseParsed.get("issues");
        if (startAtRet == null || maxResults == null || total == null) {
            throw new IllegalArgumentException("Bad response structure from JIRA: startAt=" + startAtRet + " maxResults=" + maxResults + " total=" + total);
        }
        return new ChangedIssuesResults(issues, startAtRet, maxResults, total);
    }

    protected byte[] performJIRAChangedIssuesREST(String projectKey, int startAt, Date updatedAfter, Date updatedBefore) throws Exception {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("jql", this.prepareJIRAChangedIssuesJQL(projectKey, updatedAfter, updatedBefore)));
        if (this.listJIRAIssuesMax > 0) {
            params.add((NameValuePair)new BasicNameValuePair("maxResults", "" + this.listJIRAIssuesMax));
        }
        params.add((NameValuePair)new BasicNameValuePair("startAt", startAt + ""));
        if (this.indexStructureBuilder != null) {
            String expands;
            String fields = this.indexStructureBuilder.getRequiredJIRACallIssueFields();
            if (fields != null) {
                params.add((NameValuePair)new BasicNameValuePair("fields", fields));
            }
            if ((expands = this.indexStructureBuilder.getRequiredJIRACallIssueExpands()) != null && expands.length() > 0) {
                params.add((NameValuePair)new BasicNameValuePair("expand", expands));
            }
        }
        return this.performJIRAGetRESTCall("search", params);
    }

    protected String prepareJIRAChangedIssuesJQL(String projectKey, Date updatedAfter, Date updatedBefore) {
        if (Utils.isEmpty(projectKey)) {
            throw new IllegalArgumentException("projectKey must be defined");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("project='").append(projectKey).append("'");
        if (updatedAfter != null) {
            sb.append(" and updatedDate >= \"").append(this.formatJQLDate(updatedAfter)).append("\"");
        }
        if (updatedBefore != null) {
            sb.append(" and updatedDate <= \"").append(this.formatJQLDate(updatedBefore)).append("\"");
        }
        sb.append(" ORDER BY updated ASC");
        logger.debug("JIRA JQL string: {}", new Object[]{sb.toString()});
        return sb.toString();
    }

    @Override
    public void setJQLDateFormatTimezone(TimeZone zone) {
        this.jqlDateFormat.setTimeZone(zone);
    }

    protected synchronized String formatJQLDate(Date date) {
        String ret = null;
        if (date != null) {
            ret = this.jqlDateFormat.format(date);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] performJIRAGetRESTCall(String restOperation, List<NameValuePair> params) throws Exception {
        String url = this.jiraRestAPIUrlBase + restOperation;
        logger.debug("Go to perform JIRA REST API call to the {} with parameters {}", new Object[]{url, params});
        URIBuilder builder = new URIBuilder(url);
        if (params != null) {
            for (NameValuePair param : params) {
                builder.addParameter(param.getName(), param.getValue());
            }
        }
        HttpGet method = new HttpGet(builder.build());
        method.addHeader("Accept", "application/json");
        try {
            HttpHost targetHost = new HttpHost(builder.getHost(), builder.getPort(), builder.getScheme());
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, (AuthScheme)basicAuth);
            BasicHttpContext localcontext = new BasicHttpContext();
            localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
            HttpResponse response = this.httpclient.execute((HttpUriRequest)method, (HttpContext)localcontext);
            int statusCode = response.getStatusLine().getStatusCode();
            byte[] responseContent = null;
            if (response.getEntity() != null) {
                responseContent = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            }
            if (statusCode != 200) {
                throw new Exception("Failed JIRA REST API call. HTTP error code: " + statusCode + " Response body: " + responseContent);
            }
            byte[] byArray = responseContent;
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public void setIndexStructureBuilder(IJIRAIssueIndexStructureBuilder indexStructureBuilder) {
        this.indexStructureBuilder = indexStructureBuilder;
    }

    @Override
    public IJIRAIssueIndexStructureBuilder getIndexStructureBuilder() {
        return this.indexStructureBuilder;
    }

    @Override
    public void setListJIRAIssuesMax(int listJIRAIssuesMax) {
        this.listJIRAIssuesMax = listJIRAIssuesMax;
    }

    @Override
    public int getListJIRAIssuesMax() {
        return this.listJIRAIssuesMax;
    }

    @Override
    public String getJiraAPIUrlBase() {
        return this.jiraRestAPIUrlBase;
    }
}

