/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.jira.mgm.incrementalupdate;

import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jboss.elasticsearch.river.jira.IJiraRiverMgm;
import org.jboss.elasticsearch.river.jira.mgm.TransportJRMgmBaseAction;
import org.jboss.elasticsearch.river.jira.mgm.incrementalupdate.IncrementalUpdateRequest;
import org.jboss.elasticsearch.river.jira.mgm.incrementalupdate.IncrementalUpdateResponse;
import org.jboss.elasticsearch.river.jira.mgm.incrementalupdate.NodeIncrementalUpdateRequest;
import org.jboss.elasticsearch.river.jira.mgm.incrementalupdate.NodeIncrementalUpdateResponse;

public class TransportIncrementalUpdateAction
extends TransportJRMgmBaseAction<IncrementalUpdateRequest, IncrementalUpdateResponse, NodeIncrementalUpdateRequest, NodeIncrementalUpdateResponse> {
    @Inject
    public TransportIncrementalUpdateAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService) {
        super(settings, "jira_river/force_incremental_update", clusterName, threadPool, clusterService, transportService);
    }

    @Override
    protected NodeIncrementalUpdateResponse performOperationOnJiraRiver(IJiraRiverMgm river, IncrementalUpdateRequest req, DiscoveryNode node) throws Exception {
        this.logger.debug("Go to schedule incremental reindex for river '{}' and project {}", new Object[]{req.getRiverName(), req.getProjectKey()});
        String ret = river.forceIncrementalReindex(req.getProjectKey());
        return new NodeIncrementalUpdateResponse(node, true, ret != null, ret);
    }

    protected IncrementalUpdateRequest newRequest() {
        return new IncrementalUpdateRequest();
    }

    protected NodeIncrementalUpdateRequest newNodeRequest() {
        return new NodeIncrementalUpdateRequest();
    }

    protected NodeIncrementalUpdateRequest newNodeRequest(String nodeId, IncrementalUpdateRequest request) {
        return new NodeIncrementalUpdateRequest(nodeId, request);
    }

    protected NodeIncrementalUpdateResponse newNodeResponse() {
        return new NodeIncrementalUpdateResponse(this.clusterService.localNode());
    }

    protected NodeIncrementalUpdateResponse[] newNodeResponseArray(int len) {
        return new NodeIncrementalUpdateResponse[len];
    }

    protected IncrementalUpdateResponse newResponse(ClusterName clusterName, NodeIncrementalUpdateResponse[] array) {
        return new IncrementalUpdateResponse(clusterName, array);
    }
}

