/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote.mgm.fullupdate;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jboss.elasticsearch.river.remote.Utils;
import org.jboss.elasticsearch.river.remote.mgm.JRMgmBaseRequest;

public class FullUpdateRequest
extends JRMgmBaseRequest {
    private String spaceKey;

    FullUpdateRequest() {
    }

    public FullUpdateRequest(String riverName, String spaceKey) {
        super(riverName);
        this.spaceKey = spaceKey;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public boolean isSpaceKeyRequest() {
        return !Utils.isEmpty(this.spaceKey);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.spaceKey = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.spaceKey);
    }

    public String toString() {
        return "FullUpdateRequest [spaceKey=" + this.spaceKey + ", riverName=" + this.riverName + "]";
    }
}

