/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote.mgm.fullupdate;

import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.jboss.elasticsearch.river.remote.mgm.JRMgmBaseActionListener;
import org.jboss.elasticsearch.river.remote.mgm.RestJRMgmBaseAction;
import org.jboss.elasticsearch.river.remote.mgm.fullupdate.FullUpdateAction;
import org.jboss.elasticsearch.river.remote.mgm.fullupdate.FullUpdateRequest;
import org.jboss.elasticsearch.river.remote.mgm.fullupdate.FullUpdateResponse;
import org.jboss.elasticsearch.river.remote.mgm.fullupdate.NodeFullUpdateResponse;

public class RestFullUpdateAction
extends RestJRMgmBaseAction {
    @Inject
    protected RestFullUpdateAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        String baseUrl = this.baseRestMgmUrl();
        controller.registerHandler(RestRequest.Method.POST, baseUrl + "fullupdate", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, baseUrl + "fullupdate/{spaceKey}", (RestHandler)this);
    }

    public void handleRequest(RestRequest restRequest, RestChannel restChannel) {
        final String riverName = restRequest.param("riverName");
        final String spaceKey = restRequest.param("spaceKey");
        FullUpdateRequest actionRequest = new FullUpdateRequest(riverName, spaceKey);
        this.client.execute((Action)FullUpdateAction.INSTANCE, (ActionRequest)actionRequest, (ActionListener)new JRMgmBaseActionListener<FullUpdateRequest, FullUpdateResponse, NodeFullUpdateResponse>(actionRequest, restRequest, restChannel){

            @Override
            protected void handleRiverResponse(NodeFullUpdateResponse nodeInfo) throws Exception {
                if (((FullUpdateRequest)this.actionRequest).isSpaceKeyRequest() && !nodeInfo.spaceFound) {
                    this.restChannel.sendResponse((RestResponse)new XContentRestResponse(this.restRequest, RestStatus.NOT_FOUND, 1.buildMessageDocument(this.restRequest, "Space '" + spaceKey + "' is not indexed by RemoteRiver with name: " + riverName)));
                } else {
                    this.restChannel.sendResponse((RestResponse)new XContentRestResponse(this.restRequest, RestStatus.OK, 1.buildMessageDocument(this.restRequest, "Scheduled full reindex for Spaces: " + nodeInfo.reindexedSpaces)));
                }
            }
        });
    }
}

