/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import org.elasticsearch.common.settings.SettingsException;
import org.jboss.elasticsearch.river.remote.Utils;

public enum CommentIndexingMode {
    NONE("none", false),
    EMBEDDED("embedded", false),
    CHILD("child", true),
    STANDALONE("standalone", true);

    private String configValue;
    private boolean extraDocumentIndexed;

    private CommentIndexingMode(String configValue, boolean extraDocumentIndexed) {
        this.configValue = configValue;
        this.extraDocumentIndexed = extraDocumentIndexed;
    }

    public String getConfigValue() {
        return this.configValue;
    }

    public boolean isExtraDocumentIndexed() {
        return this.extraDocumentIndexed;
    }

    public static CommentIndexingMode parseConfiguration(String value) throws SettingsException {
        if (Utils.isEmpty(value)) {
            return NONE;
        }
        if (NONE.getConfigValue().equalsIgnoreCase(value)) {
            return NONE;
        }
        if (CHILD.getConfigValue().equalsIgnoreCase(value)) {
            return CHILD;
        }
        if (STANDALONE.getConfigValue().equalsIgnoreCase(value)) {
            return STANDALONE;
        }
        if (EMBEDDED.getConfigValue().equalsIgnoreCase(value)) {
            return EMBEDDED;
        }
        throw new SettingsException("unsupported value for comments indexing mode: " + value);
    }
}

