/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.river.remote.IDocumentIndexStructureBuilder;
import org.jboss.elasticsearch.river.remote.IPwdLoader;
import org.jboss.elasticsearch.river.remote.IRemoteSystemClient;
import org.jboss.elasticsearch.river.remote.Utils;

public abstract class HttpRemoteSystemClientBase
implements IRemoteSystemClient {
    protected static final String CFG_PASSWORD = "pwd";
    protected static final String CFG_USERNAME = "username";
    protected static final String CFG_TIMEOUT = "timeout";
    protected ESLogger myLogger = null;
    protected HttpClient httpclient;
    protected boolean isAuthConfigured = false;
    protected IDocumentIndexStructureBuilder indexStructureBuilder;

    protected String initHttpClient(ESLogger logger, Map<String, Object> config, IPwdLoader pwdLoader, String url) {
        this.myLogger = logger;
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(20);
        connectionManager.setMaxTotal(20);
        DefaultHttpClient httpclientImpl = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        this.httpclient = httpclientImpl;
        HttpParams params = this.httpclient.getParams();
        params.setParameter("http.protocol.content-charset", (Object)"UTF-8");
        Integer timeout = new Long(Utils.parseTimeValue(config, CFG_TIMEOUT, 5L, TimeUnit.SECONDS)).intValue();
        if (timeout != null) {
            params.setParameter("http.socket.timeout", (Object)timeout);
            params.setParameter("http.connection.timeout", (Object)timeout);
        }
        String remoteUsername = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)config.get(CFG_USERNAME), null));
        String remotePassword = XContentMapValues.nodeStringValue((Object)config.get(CFG_PASSWORD), null);
        if (remoteUsername != null) {
            if (remotePassword == null && pwdLoader != null) {
                remotePassword = pwdLoader.loadPassword(remoteUsername);
            }
            if (remotePassword != null) {
                try {
                    URL urlParsed = new URL(url);
                    String host = urlParsed.getHost();
                    httpclientImpl.getCredentialsProvider().setCredentials(new AuthScope(host, -1), (Credentials)new UsernamePasswordCredentials(remoteUsername, remotePassword));
                    this.isAuthConfigured = true;
                }
                catch (MalformedURLException e) {}
            } else {
                logger.warn("Password not found so authentication is not used!", new Object[0]);
                remoteUsername = null;
            }
        } else {
            remoteUsername = null;
        }
        return remoteUsername;
    }

    protected static String getUrlFromConfig(Map<String, Object> config, String cfgProperyName, boolean mandatory) throws SettingsException {
        String url = null;
        if (config != null) {
            url = Utils.trimToNull(XContentMapValues.nodeStringValue((Object)config.get(cfgProperyName), null));
        }
        if (mandatory && url == null) {
            throw new SettingsException("remote/" + cfgProperyName + " element of configuration structure not found or empty");
        }
        if (url != null) {
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                throw new SettingsException("Parameter remote/" + cfgProperyName + " is malformed URL " + e.getMessage());
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponseContent performHttpGetCall(String url, Map<String, String> headers) throws Exception, HttpCallException {
        this.myLogger.debug("Going to perform remote system HTTP GET request to the the {}", new Object[]{url});
        URIBuilder builder = new URIBuilder(url);
        HttpGet method = new HttpGet(builder.build());
        if (headers != null) {
            for (String headerName : headers.keySet()) {
                method.addHeader(headerName, headers.get(headerName));
            }
        }
        try {
            BasicHttpContext localcontext = new BasicHttpContext();
            if (this.isAuthConfigured) {
                HttpHost targetHost = new HttpHost(builder.getHost(), builder.getPort(), builder.getScheme());
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(targetHost, (AuthScheme)basicAuth);
                localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
            }
            HttpResponse response = this.httpclient.execute((HttpUriRequest)method, (HttpContext)localcontext);
            int statusCode = response.getStatusLine().getStatusCode();
            byte[] responseContent = null;
            if (response.getEntity() != null) {
                responseContent = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            }
            if (statusCode != 200) {
                throw new HttpCallException(url, statusCode, responseContent != null ? new String(responseContent) : "");
            }
            Header h = response.getFirstHeader("Content-Type");
            HttpResponseContent httpResponseContent = new HttpResponseContent(h != null ? h.getValue() : null, responseContent);
            return httpResponseContent;
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public void setIndexStructureBuilder(IDocumentIndexStructureBuilder indexStructureBuilder) {
        this.indexStructureBuilder = indexStructureBuilder;
    }

    @Override
    public IDocumentIndexStructureBuilder getIndexStructureBuilder() {
        return this.indexStructureBuilder;
    }

    public static final class HttpCallException
    extends Exception {
        int statusCode;

        public HttpCallException(String url, int statusCode, String responseContent) {
            super("Failed remote system HTTP GET request to the url '" + url + "'. HTTP error code: " + statusCode + " Response body: " + responseContent);
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }

    public static final class HttpResponseContent {
        public String contentType;
        public byte[] content;

        public HttpResponseContent(String contentType, byte[] content) {
            this.contentType = contentType;
            this.content = content;
        }

        public String toString() {
            return "HttpResponseContent [contentType=" + this.contentType + ", content=" + this.content != null ? new String(this.content) : "]";
        }
    }
}

