/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote.mgm.riverslist;

import java.io.IOException;
import java.util.HashSet;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.ClusterAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.jboss.elasticsearch.river.remote.mgm.RestJRMgmBaseAction;
import org.jboss.elasticsearch.river.remote.mgm.riverslist.ListRiversAction;
import org.jboss.elasticsearch.river.remote.mgm.riverslist.ListRiversRequest;
import org.jboss.elasticsearch.river.remote.mgm.riverslist.ListRiversResponse;
import org.jboss.elasticsearch.river.remote.mgm.riverslist.NodeListRiversResponse;

public class RestListRiversAction
extends RestJRMgmBaseAction {
    @Inject
    protected RestListRiversAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_remote_river/list", (RestHandler)this);
    }

    public void handleRequest(RestRequest restRequest, final RestChannel restChannel) {
        ListRiversRequest actionRequest = new ListRiversRequest();
        this.logger.debug("Go to look for remote rivers in the cluster", new Object[0]);
        this.client.admin().cluster().execute((ClusterAction)ListRiversAction.INSTANCE, (ActionRequest)actionRequest, (ActionListener)new ActionListener<ListRiversResponse>(){

            public void onResponse(ListRiversResponse response) {
                try {
                    HashSet<String> allRivers = new HashSet<String>();
                    for (NodeListRiversResponse node : (NodeListRiversResponse[])response.getNodes()) {
                        if (node.getRiverNames() == null) continue;
                        allRivers.addAll(node.getRiverNames());
                    }
                    XContentBuilder builder = restChannel.newBuilder();
                    builder.startObject();
                    builder.field("river_names", allRivers);
                    builder.endObject();
                    restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Throwable e) {
                try {
                    restChannel.sendResponse((RestResponse)new BytesRestResponse(restChannel, e));
                }
                catch (IOException e1) {
                    RestListRiversAction.this.logger.error("Failed to send failure response", (Throwable)e1, new Object[0]);
                }
            }
        });
    }
}

