/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote.mgm.fullupdate;

import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jboss.elasticsearch.river.remote.IRiverMgm;
import org.jboss.elasticsearch.river.remote.mgm.TransportJRMgmBaseAction;
import org.jboss.elasticsearch.river.remote.mgm.fullupdate.FullUpdateRequest;
import org.jboss.elasticsearch.river.remote.mgm.fullupdate.FullUpdateResponse;
import org.jboss.elasticsearch.river.remote.mgm.fullupdate.NodeFullUpdateRequest;
import org.jboss.elasticsearch.river.remote.mgm.fullupdate.NodeFullUpdateResponse;

public class TransportFullUpdateAction
extends TransportJRMgmBaseAction<FullUpdateRequest, FullUpdateResponse, NodeFullUpdateRequest, NodeFullUpdateResponse> {
    @Inject
    public TransportFullUpdateAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService) {
        super(settings, "remote_river/force_full_update", clusterName, threadPool, clusterService, transportService);
    }

    @Override
    protected NodeFullUpdateResponse performOperationOnRiver(IRiverMgm river, FullUpdateRequest req, DiscoveryNode node) throws Exception {
        this.logger.debug("Go to schedule full reindex for river '{}' and space {}", new Object[]{req.getRiverName(), req.getSpaceKey()});
        String ret = river.forceFullReindex(req.getSpaceKey());
        return new NodeFullUpdateResponse(node, true, ret != null, ret);
    }

    protected FullUpdateRequest newRequest() {
        return new FullUpdateRequest();
    }

    protected NodeFullUpdateRequest newNodeRequest() {
        return new NodeFullUpdateRequest();
    }

    protected NodeFullUpdateRequest newNodeRequest(String nodeId, FullUpdateRequest request) {
        return new NodeFullUpdateRequest(nodeId, request);
    }

    protected NodeFullUpdateResponse newNodeResponse() {
        return new NodeFullUpdateResponse(this.clusterService.localNode());
    }

    protected NodeFullUpdateResponse[] newNodeResponseArray(int len) {
        return new NodeFullUpdateResponse[len];
    }

    protected FullUpdateResponse newResponse(ClusterName clusterName, NodeFullUpdateResponse[] array) {
        return new FullUpdateResponse(clusterName, array);
    }
}

