/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.elasticsearch.common.joda.time.format.ISODateTimeFormat;
import org.jboss.elasticsearch.river.remote.Utils;

public abstract class DateTimeUtils {
    protected static final SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SZ");

    public static final Date parseISODateTime(String dateString) {
        if (Utils.isEmpty(dateString)) {
            return null;
        }
        return ISODateTimeFormat.dateTimeParser().parseDateTime(dateString).toDate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String formatISODateTime(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = ISO_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return ISO_DATE_FORMAT.format(date);
        }
    }

    public static Date parseISODateTimeWithMinutePrecise(String dateString) {
        if (Utils.isEmpty(dateString)) {
            return null;
        }
        return DateTimeUtils.roundDateTimeToMinutePrecise(ISODateTimeFormat.dateTimeParser().parseDateTime(dateString).toDate());
    }

    public static Date roundDateTimeToMinutePrecise(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    static {
        ISO_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

