/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.common.joda.time.format.DateTimeFormat;
import org.elasticsearch.common.joda.time.format.DateTimeFormatter;
import org.elasticsearch.common.joda.time.format.ISODateTimeFormat;
import org.jboss.elasticsearch.river.remote.Utils;

public abstract class DateTimeUtils {
    public static final String CUSTOM_MILISEC_EPOCH_DATETIME_FORMAT = "{milisecondEpoch}";
    public static final String CUSTOM_UNIX_EPOCH_DATETIME_FORMAT = "{unixEpoch}";
    private static final Map<String, DateTimeFormatter> dateTimeFormattersCache = new ConcurrentHashMap<String, DateTimeFormatter>();
    protected static final SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SZ");

    public static final Date parseISODateTime(String dateString) {
        if (Utils.isEmpty(dateString)) {
            return null;
        }
        return ISODateTimeFormat.dateTimeParser().parseDateTime(dateString).toDate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String formatISODateTime(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = ISO_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return ISO_DATE_FORMAT.format(date);
        }
    }

    public static Date parseISODateTimeWithMinutePrecise(String dateString) {
        if (Utils.isEmpty(dateString)) {
            return null;
        }
        return DateTimeUtils.roundDateTimeToMinutePrecise(ISODateTimeFormat.dateTimeParser().parseDateTime(dateString).toDate());
    }

    public static Date roundDateTimeToMinutePrecise(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static String formatDateTime(Date date, String format) {
        if (date == null) {
            return null;
        }
        if (format == null || format.trim().length() == 0) {
            return DateTimeUtils.formatISODateTime(date);
        }
        switch (format) {
            case "{milisecondEpoch}": {
                return String.valueOf(date.getTime());
            }
            case "{unixEpoch}": {
                return String.valueOf(date.getTime() / 1000L);
            }
        }
        if (dateTimeFormattersCache.containsKey(format)) {
            return dateTimeFormattersCache.get(format).print(date.getTime());
        }
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)format);
        dateTimeFormattersCache.put(format, dtf);
        return dtf.print(date.getTime());
    }

    static {
        ISO_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

