/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import java.util.Map;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.jboss.elasticsearch.river.remote.ChangedDocumentsResults;
import org.jboss.elasticsearch.river.remote.IDocumentIndexStructureBuilder;
import org.jboss.elasticsearch.river.remote.IESIntegration;
import org.jboss.elasticsearch.river.remote.IRemoteSystemClient;
import org.jboss.elasticsearch.river.remote.SpaceIndexerBase;
import org.jboss.elasticsearch.river.remote.SpaceIndexingInfo;

public class SpacePaginatingIndexer
extends SpaceIndexerBase {
    public SpacePaginatingIndexer(String spaceKey, IRemoteSystemClient remoteSystemClient, IESIntegration esIntegrationComponent, IDocumentIndexStructureBuilder documentIndexStructureBuilder) {
        super(spaceKey, remoteSystemClient, esIntegrationComponent, documentIndexStructureBuilder);
        this.logger = esIntegrationComponent.createLogger(SpacePaginatingIndexer.class);
        this.indexingInfo = new SpaceIndexingInfo(spaceKey, true);
    }

    @Override
    protected void processUpdate() throws Exception {
        this.indexingInfo.documentsUpdated = 0;
        int startAt = 0;
        this.logger.info("Go to perform full update for Space {}", new Object[]{this.spaceKey});
        boolean cont = true;
        while (cont) {
            ChangedDocumentsResults res;
            if (this.isClosed()) {
                throw new InterruptedException("Interrupted because River is closed");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Go to ask remote system for updated documents for space {} with startAt {}", new Object[]{this.spaceKey, startAt});
            }
            if ((res = this.remoteSystemClient.getChangedDocuments(this.spaceKey, startAt, this.indexingInfo.fullUpdate, null)).getDocumentsCount() == 0) {
                cont = false;
                continue;
            }
            if (this.isClosed()) {
                throw new InterruptedException("Interrupted because River is closed");
            }
            int updatedInThisBulk = 0;
            boolean deletedInThisBulk = false;
            BulkRequestBuilder esBulk = this.esIntegrationComponent.prepareESBulkRequestBuilder();
            for (Map<String, Object> document : res.getDocuments()) {
                String documentId = this.getDocumentIdChecked(document);
                if (this.getDocumentDetail(documentId, document)) {
                    this.logger.debug("Go to update index for document '{}'", new Object[]{documentId});
                    if (this.documentIndexStructureBuilder.extractDocumentDeleted(document)) {
                        deletedInThisBulk = this.prepareDeleteByRemoteDocumentId(esBulk, documentId) || deletedInThisBulk;
                    } else {
                        this.documentIndexStructureBuilder.indexDocument(esBulk, this.spaceKey, document);
                        ++updatedInThisBulk;
                    }
                }
                if (!this.isClosed()) continue;
                throw new InterruptedException("Interrupted because River is closed");
            }
            if (updatedInThisBulk > 0 || deletedInThisBulk) {
                this.executeBulkUpdate(esBulk);
                this.indexingInfo.documentsUpdated += updatedInThisBulk;
            }
            startAt = res.getStartAt() + res.getDocumentsCount();
            if (res.getTotal() == null) continue;
            cont = res.getTotal() > startAt;
        }
    }
}

