/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote.sitemap;

import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jboss.elasticsearch.river.remote.sitemap.SiteMap;

public abstract class AbstractSiteMap {
    private Date lastModified = null;
    private SitemapType type;
    private boolean processed;
    protected URL url;
    private static final ThreadLocal<DateFormat[]> dateFormats = new ThreadLocal<DateFormat[]>(){

        @Override
        protected DateFormat[] initialValue() {
            DateFormat[] df;
            for (DateFormat d : df = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm+hh:00", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm-hh:00", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss+hh:00", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss-hh:00", Locale.US), new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("yyyy-MM-dd", Locale.US)}) {
                d.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
            return df;
        }
    };

    public static DateFormat getFullDateFormat() {
        return dateFormats.get()[1];
    }

    public boolean isIndex() {
        return this.type == SitemapType.INDEX;
    }

    public URL getUrl() {
        return this.url;
    }

    void setType(SitemapType type) {
        this.type = type;
    }

    public SitemapType getType() {
        return this.type;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = SiteMap.convertToDate(lastModified);
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public static Date convertToDate(String date) {
        if (date != null) {
            for (DateFormat df : dateFormats.get()) {
                try {
                    return df.parse(date);
                }
                catch (ParseException e) {
                }
            }
        }
        return null;
    }

    public static enum SitemapType {
        INDEX,
        XML,
        ATOM,
        RSS,
        TEXT;

    }
}

