/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.remote;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.jboss.elasticsearch.river.remote.DateTimeUtils;
import org.jboss.elasticsearch.river.remote.Utils;

public class SpaceIndexingInfo {
    private static final String DOCFIELD_DOCUMENTS_DELETED = "documents_deleted";
    private static final String DOCFIELD_COMMENTS_DELETED = "comments_deleted";
    private static final String DOCVAL_RESULT_OK = "OK";
    private static final String DOCVAL_TYPE_FULL = "FULL";
    public static final String DOCFIELD_ERROR_MESSAGE = "error_message";
    public static final String DOCFIELD_TIME_ELAPSED = "time_elapsed";
    public static final String DOCFIELD_RESULT = "result";
    public static final String DOCFIELD_DOCUMENTS_UPDATED = "documents_updated";
    public static final String DOCFIELD_DOCUMENTS_WITH_ERROR = "documents_with_error";
    public static final String DOCFIELD_UPDATE_TYPE = "update_type";
    public static final String DOCFIELD_START_DATE = "start_date";
    public static final String DOCFIELD_SPACE_KEY = "space_key";
    public static final String DOCFIELD_RIVER_NAME = "river_name";
    public String spaceKey;
    public boolean fullUpdate;
    public int documentsUpdated;
    public int documentsDeleted;
    public int documentsWithError;
    public int commentsDeleted;
    public Date startDate;
    public boolean finishedOK;
    public long timeElapsed;
    private StringBuilder errorMessage = new StringBuilder();

    public SpaceIndexingInfo(String spaceKey, boolean fullUpdate) {
        this.spaceKey = spaceKey;
        this.fullUpdate = fullUpdate;
    }

    public SpaceIndexingInfo(String spaceKey, boolean fullUpdate, int documentsUpdated, int documentsDeleted, int commentsDeleted, Date startDate, boolean finishedOK, long timeElapsed, String errorMessage) {
        this.spaceKey = spaceKey;
        this.fullUpdate = fullUpdate;
        this.documentsUpdated = documentsUpdated;
        this.documentsDeleted = documentsDeleted;
        this.commentsDeleted = commentsDeleted;
        this.startDate = startDate;
        this.finishedOK = finishedOK;
        this.timeElapsed = timeElapsed;
        errorMessage = Utils.trimToNull(errorMessage);
        if (errorMessage != null) {
            this.errorMessage.append(errorMessage);
        }
    }

    public void addErrorMessage(String msgRow) {
        if ((msgRow = Utils.trimToNull(msgRow)) != null) {
            if (this.errorMessage.length() != 0) {
                this.errorMessage.append("\n");
            }
            this.errorMessage.append(msgRow);
        }
    }

    public String getErrorMessage() {
        if (this.errorMessage.length() == 0) {
            return null;
        }
        return this.errorMessage.toString();
    }

    public XContentBuilder buildDocument(XContentBuilder builder, String riverName, boolean printSpaceKey, boolean printFinalStatus) throws IOException {
        builder.startObject();
        if (riverName != null) {
            builder.field(DOCFIELD_RIVER_NAME, riverName);
        }
        if (printSpaceKey) {
            builder.field(DOCFIELD_SPACE_KEY, this.spaceKey);
        }
        builder.field(DOCFIELD_UPDATE_TYPE, this.fullUpdate ? DOCVAL_TYPE_FULL : "INCREMENTAL");
        builder.field(DOCFIELD_START_DATE, this.startDate);
        builder.field(DOCFIELD_DOCUMENTS_UPDATED, this.documentsUpdated);
        builder.field(DOCFIELD_DOCUMENTS_DELETED, this.documentsDeleted);
        builder.field(DOCFIELD_COMMENTS_DELETED, this.commentsDeleted);
        builder.field(DOCFIELD_DOCUMENTS_WITH_ERROR, this.documentsWithError);
        if (printFinalStatus) {
            builder.field(DOCFIELD_RESULT, this.finishedOK ? DOCVAL_RESULT_OK : "ERROR");
            builder.field(DOCFIELD_TIME_ELAPSED, this.timeElapsed + "ms");
            if (!Utils.isEmpty(this.getErrorMessage())) {
                builder.field(DOCFIELD_ERROR_MESSAGE, this.getErrorMessage());
            }
        }
        builder.endObject();
        return builder;
    }

    public static SpaceIndexingInfo readFromDocument(Map<String, Object> document) {
        if (document == null) {
            return null;
        }
        SpaceIndexingInfo ret = new SpaceIndexingInfo((String)document.get(DOCFIELD_SPACE_KEY), DOCVAL_TYPE_FULL.equals(document.get(DOCFIELD_UPDATE_TYPE)));
        ret.startDate = DateTimeUtils.parseISODateTime((String)document.get(DOCFIELD_START_DATE));
        ret.documentsUpdated = Utils.nodeIntegerValue(document.get(DOCFIELD_DOCUMENTS_UPDATED));
        ret.documentsDeleted = Utils.nodeIntegerValue(document.get(DOCFIELD_DOCUMENTS_DELETED));
        ret.commentsDeleted = Utils.nodeIntegerValue(document.get(DOCFIELD_COMMENTS_DELETED));
        ret.documentsWithError = Utils.nodeIntegerValue(document.get(DOCFIELD_DOCUMENTS_WITH_ERROR));
        ret.finishedOK = DOCVAL_RESULT_OK.equals(document.get(DOCFIELD_RESULT));
        ret.timeElapsed = Long.parseLong(((String)document.get(DOCFIELD_TIME_ELAPSED)).replace("ms", ""));
        ret.addErrorMessage((String)document.get(DOCFIELD_ERROR_MESSAGE));
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.spaceKey == null ? 0 : this.spaceKey.hashCode());
        return result;
    }
}

