/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.sysinfo.mgm.riverslist;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.support.nodes.TransportNodesOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jboss.elasticsearch.river.sysinfo.SysinfoRiver;
import org.jboss.elasticsearch.river.sysinfo.mgm.riverslist.ListRiversRequest;
import org.jboss.elasticsearch.river.sysinfo.mgm.riverslist.ListRiversResponse;
import org.jboss.elasticsearch.river.sysinfo.mgm.riverslist.NodeListRiversRequest;
import org.jboss.elasticsearch.river.sysinfo.mgm.riverslist.NodeListRiversResponse;

public class TransportListRiversAction
extends TransportNodesOperationAction<ListRiversRequest, ListRiversResponse, NodeListRiversRequest, NodeListRiversResponse> {
    protected static final ESLogger logger = Loggers.getLogger(TransportListRiversAction.class);

    @Inject
    public TransportListRiversAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService) {
        super(settings, clusterName, threadPool, clusterService, transportService);
    }

    protected String executor() {
        return "management";
    }

    protected ListRiversResponse newResponse(ListRiversRequest request, AtomicReferenceArray responses) {
        ArrayList<NodeListRiversResponse> nodesInfos = new ArrayList<NodeListRiversResponse>();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (!(resp instanceof NodeListRiversResponse)) continue;
            nodesInfos.add((NodeListRiversResponse)((Object)resp));
        }
        return new ListRiversResponse(this.clusterName, nodesInfos.toArray(new NodeListRiversResponse[nodesInfos.size()]));
    }

    protected boolean accumulateExceptions() {
        return false;
    }

    protected NodeListRiversResponse nodeOperation(NodeListRiversRequest nodeRequest) throws ElasticsearchException {
        logger.debug("Go to look for Sysinfo rivers on this node", new Object[0]);
        return new NodeListRiversResponse(this.clusterService.localNode(), SysinfoRiver.getRunningInstances());
    }

    protected String transportAction() {
        return "sysinfo_river/list_river_names";
    }

    protected ListRiversRequest newRequest() {
        return new ListRiversRequest();
    }

    protected NodeListRiversRequest newNodeRequest() {
        return new NodeListRiversRequest();
    }

    protected NodeListRiversRequest newNodeRequest(String nodeId, ListRiversRequest request) {
        return new NodeListRiversRequest(nodeId, request);
    }

    protected NodeListRiversResponse newNodeResponse() {
        return new NodeListRiversResponse(this.clusterService.localNode());
    }
}

