/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.sysinfo;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.river.AbstractRiverComponent;
import org.elasticsearch.river.River;
import org.elasticsearch.river.RiverName;
import org.elasticsearch.river.RiverSettings;
import org.jboss.elasticsearch.river.sysinfo.IRiverMgm;
import org.jboss.elasticsearch.river.sysinfo.SourceClient;
import org.jboss.elasticsearch.river.sysinfo.SourceClientREST;
import org.jboss.elasticsearch.river.sysinfo.SysinfoIndexer;
import org.jboss.elasticsearch.river.sysinfo.SysinfoType;
import org.jboss.elasticsearch.river.sysinfo.Utils;
import org.jboss.elasticsearch.river.sysinfo.esclient.SourceClientESClient;
import org.jboss.elasticsearch.river.sysinfo.esclient.SourceClientESTransportClient;

public class SysinfoRiver
extends AbstractRiverComponent
implements River,
IRiverMgm {
    protected static Map<String, IRiverMgm> riverInstances = new HashMap<String, IRiverMgm>();
    protected Client client;
    protected volatile boolean closed = true;
    protected SourceClient sourceClient;
    protected Map<String, SysinfoIndexer> indexers = new LinkedHashMap<String, SysinfoIndexer>();
    protected Map<String, Thread> indexerThreads = new LinkedHashMap<String, Thread>();

    @Inject
    public SysinfoRiver(RiverName riverName, RiverSettings settings, Client client) throws MalformedURLException {
        super(riverName, settings);
        this.client = client;
        this.configure(settings.settings());
    }

    protected SysinfoRiver(RiverName riverName, RiverSettings settings) {
        super(riverName, settings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void configure(Map<String, Object> settings) {
        if (!this.closed) {
            throw new IllegalStateException("Sysinfo River must be stopped to configure it!");
        }
        String type = null;
        if (!settings.containsKey("es_connection")) throw new SettingsException("'es_connection' element of river configuration structure not found");
        Map sourceClientSettings = (Map)settings.get("es_connection");
        type = XContentMapValues.nodeStringValue(sourceClientSettings.get("type"), null);
        if (Utils.isEmpty(type)) {
            throw new SettingsException("es_connection/type element of configuration structure not found or empty");
        }
        if ("local".equalsIgnoreCase(type)) {
            this.sourceClient = new SourceClientESClient(this.client);
        } else if ("remote".equalsIgnoreCase(type)) {
            this.sourceClient = new SourceClientESTransportClient(sourceClientSettings);
        } else {
            if (!"rest".equalsIgnoreCase(type)) throw new SettingsException("es_connection/type value '" + type + "' is invalid. Use one of local, remote, rest");
            this.sourceClient = new SourceClientREST(sourceClientSettings);
        }
        Map indexersMap = (Map)settings.get("indexers");
        if (indexersMap == null || indexersMap.isEmpty()) throw new SettingsException("'indexers' element of river configuration structure not found or is empty");
        for (String name : indexersMap.keySet()) {
            if (this.indexers.containsKey(name = name.trim())) {
                throw new SettingsException("Duplicate 'indexers/" + name + "' section");
            }
            Map ic = (Map)indexersMap.get(name);
            SysinfoType infoType = SysinfoType.parseConfiguration((String)ic.get("info_type"));
            String indexName = this.configMandatoryString(ic, "index_name", name);
            String typeName = this.configMandatoryString(ic, "index_type", name);
            long indexingPeriod = Utils.parseTimeValue(ic, "period", 30L, TimeUnit.SECONDS);
            Map params = (Map)ic.get("params");
            this.indexers.put(name, new SysinfoIndexer(name, this.sourceClient, this.client, infoType, indexName, typeName, indexingPeriod, params));
        }
        this.logger.info("Sysinfo River configured for connection type '{}' and {} indexers.", new Object[]{type, this.indexers.size()});
    }

    private String configMandatoryString(Map<String, Object> settings, String key, String parentName) {
        String s = (String)settings.get(key);
        if (Utils.isEmpty(s)) {
            throw new SettingsException("'indexers/" + parentName + "/" + key + "' river configuration element not found or is empty");
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        if (!this.closed) {
            throw new IllegalStateException("Can't start already running river");
        }
        this.logger.info("starting Sysinfo River", new Object[0]);
        Map<String, IRiverMgm> map = riverInstances;
        synchronized (map) {
            SysinfoRiver.addRunningInstance(this);
        }
        this.sourceClient.start();
        this.closed = false;
        for (SysinfoIndexer indexer : this.indexers.values()) {
            this.runIndexer(indexer);
        }
        this.logger.info("Sysinfo River started", new Object[0]);
    }

    protected void runIndexer(SysinfoIndexer indexer) {
        Thread t = this.acquireThread("sysinfo_river_" + indexer.name, indexer);
        this.indexerThreads.put(indexer.name, t);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        this.logger.info("closing Sysinfo River on this node", new Object[0]);
        this.closed = true;
        try {
            this.stop();
        }
        finally {
            this.logger.info("Sysinfo River closed", new Object[0]);
            Map<String, IRiverMgm> map = riverInstances;
            synchronized (map) {
                riverInstances.remove(this.riverName().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        this.logger.info("stopping Sysinfo River indexing process", new Object[0]);
        this.closed = true;
        try {
            for (SysinfoIndexer indexer : this.indexers.values()) {
                try {
                    indexer.close();
                }
                catch (Throwable t) {
                    this.logger.warn("Exception during {} indexer closing: {}", new Object[]{indexer.name, t.getMessage()});
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            for (Thread pi : this.indexerThreads.values()) {
                pi.interrupt();
            }
            this.indexerThreads.clear();
        }
        finally {
            this.sourceClient.close();
        }
    }

    @Override
    public synchronized void restart() {
        this.logger.info("restarting Sysinfo River", new Object[0]);
        if (!this.closed) {
            this.stop();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                return;
            }
        } else {
            this.logger.debug("stopped already", new Object[0]);
        }
        this.reconfigure();
        this.start();
        this.logger.info("Sysinfo River restarted", new Object[0]);
    }

    public synchronized void reconfigure() {
        if (!this.closed) {
            throw new IllegalStateException("Sysinfo River must be stopped to reconfigure it!");
        }
        this.logger.info("reconfiguring Sysinfo River", new Object[0]);
        String riverIndexName = this.getRiverIndexName();
        this.refreshSearchIndex(riverIndexName);
        GetResponse resp = (GetResponse)this.client.prepareGet(riverIndexName, this.riverName().name(), "_meta").execute().actionGet();
        if (resp.isExists()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Configuration document: {}", new Object[]{resp.getSourceAsString()});
            }
        } else {
            throw new IllegalStateException("Configuration document not found to reconfigure river " + this.riverName().name());
        }
        Map newset = resp.getSource();
        this.indexers.clear();
        this.configure(newset);
    }

    protected String getRiverIndexName() {
        return "_river";
    }

    public void refreshSearchIndex(String indexName) {
        this.client.admin().indices().prepareRefresh(new String[]{indexName}).execute().actionGet();
    }

    public static IRiverMgm getRunningInstance(String riverName) {
        if (riverName == null) {
            return null;
        }
        return riverInstances.get(riverName);
    }

    public static void addRunningInstance(IRiverMgm river) {
        riverInstances.put(river.riverName().getName(), river);
    }

    public static void clearRunningInstances() {
        riverInstances.clear();
    }

    public static Set<String> getRunningInstances() {
        return Collections.unmodifiableSet(riverInstances.keySet());
    }

    protected Thread acquireThread(String threadName, Runnable runnable) {
        return EsExecutors.daemonThreadFactory((Settings)this.settings.globalSettings(), (String)threadName).newThread(runnable);
    }

    @Override
    public synchronized boolean changeIndexerPeriod(String[] indexerNames, long indexingPeriod) {
        this.logger.debug("Go to change period to {}[ms] for indexers {}", new Object[]{indexingPeriod, indexerNames});
        if (indexerNames == null || indexerNames.length == 0) {
            return true;
        }
        boolean ret = false;
        for (String in : indexerNames) {
            in = in.trim();
            try {
                if (!this.indexers.containsKey(in)) continue;
                ret = true;
                SysinfoIndexer si = this.indexers.get(in);
                long old = si.indexingPeriod;
                si.indexingPeriod = indexingPeriod;
                if (old <= 3000L || old <= indexingPeriod || si.closed) continue;
                si.close();
                Thread t = this.indexerThreads.get(in);
                if (t == null) continue;
                t.interrupt();
                while (t.getState() != Thread.State.TERMINATED) {
                    Thread.sleep(50L);
                }
                this.runIndexer(si);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.logger.info("Indexing period changed to {}[ms] for indexers {}", new Object[]{indexingPeriod, indexerNames});
        return ret;
    }
}

