/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.Collection;
import java.util.Map;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.InvalidDataException;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorBase;

public class RequiredValidatorPreprocessor
extends StructuredContentPreprocessorBase {
    protected static final String CFG_FIELD = "field";
    protected String field;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        if (settings == null) {
            throw new SettingsException("'settings' section is not defined for preprocessor " + this.name);
        }
        this.field = XContentMapValues.nodeStringValue((Object)settings.get(CFG_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.field, CFG_FIELD);
    }

    @Override
    public Map<String, Object> preprocessData(Map<String, Object> data) {
        Collection s;
        if (data == null) {
            return null;
        }
        Object sourceData = XContentMapValues.extractValue((String)this.field, data);
        if (sourceData == null) {
            throw new InvalidDataException("Field " + this.field + " is required");
        }
        if (sourceData instanceof String) {
            String s2 = ((String)sourceData).trim();
            if (s2.isEmpty()) {
                throw new InvalidDataException("Field " + this.field + " is required not to be empty od blank string");
            }
        } else if (sourceData instanceof Collection && (s = (Collection)sourceData).isEmpty()) {
            throw new InvalidDataException("Field " + this.field + " is required not to be empty collection");
        }
        return data;
    }
}

