/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.Map;
import org.elasticsearch.common.settings.SettingsException;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorBase;
import org.jboss.elasticsearch.tools.content.ValueUtils;

public class AddMultipleValuesPreprocessor
extends StructuredContentPreprocessorBase {
    protected Map<String, Object> fields;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        if (settings == null) {
            throw new SettingsException("'settings' section is not defined for preprocessor " + this.name);
        }
        this.fields = settings;
    }

    @Override
    public Map<String, Object> preprocessData(Map<String, Object> data) {
        if (data == null) {
            return null;
        }
        for (String key : this.fields.keySet()) {
            Object value = this.fields.get(key);
            if (value != null && value instanceof String && ((String)value).contains("{")) {
                value = ValueUtils.processStringValuePatternReplacement((String)value, data, null);
            }
            StructureUtils.putValueIntoMapOfMaps(data, key, value);
        }
        return data;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }
}

