/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.List;
import java.util.Map;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.PreprocessChainContext;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorWithSourceBasesBase;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.safety.Whitelist;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class StripHtmlPreprocessor
extends StructuredContentPreprocessorWithSourceBasesBase<Object> {
    protected static final String CFG_SOURCE_FIELD = "source_field";
    protected static final String CFG_TARGET_FIELD = "target_field";
    protected String fieldSource;
    protected String fieldTarget;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        super.init(settings);
        this.fieldSource = XContentMapValues.nodeStringValue((Object)settings.get(CFG_SOURCE_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.fieldSource, CFG_SOURCE_FIELD);
        this.fieldTarget = XContentMapValues.nodeStringValue((Object)settings.get(CFG_TARGET_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.fieldTarget, CFG_TARGET_FIELD);
    }

    @Override
    protected Object createContext() {
        return null;
    }

    @Override
    protected void processOneSourceValue(Map<String, Object> data, Object context, String base, PreprocessChainContext chainContext) {
        Object v = null;
        v = this.fieldSource.contains(".") ? XContentMapValues.extractValue((String)this.fieldSource, data) : data.get(this.fieldSource);
        if (v != null) {
            if (!(v instanceof String)) {
                String msg = "Value for field '" + StripHtmlPreprocessor.getFullFieldName(base, this.fieldSource) + "' is not String, so can't be processed";
                this.addDataWarning(chainContext, msg);
                this.logger.debug(msg, new Object[0]);
            } else {
                String value = this.stripHtml(v.toString());
                StructureUtils.putValueIntoMapOfMaps(data, this.fieldTarget, value);
            }
        }
    }

    protected String stripHtml(String value) {
        if (value == null || value.trim().isEmpty()) {
            return value;
        }
        Document doc = Jsoup.parse((String)Jsoup.clean((String)value, (Whitelist)Whitelist.relaxed()));
        return this.convertNodeToText(doc.body());
    }

    protected String convertNodeToText(Element element) {
        if (element == null) {
            return "";
        }
        final StringBuilder buffer = new StringBuilder();
        new NodeTraversor(new NodeVisitor(){

            public void head(Node node, int depth) {
                TextNode textNode;
                String text;
                if (node instanceof TextNode && !(text = (textNode = (TextNode)node).text().replace('\u00a0', ' ').trim()).isEmpty()) {
                    buffer.append(text);
                    if (!text.endsWith(" ")) {
                        buffer.append(" ");
                    }
                }
            }

            public void tail(Node node, int depth) {
            }
        }).traverse((Node)element);
        String output = buffer.toString();
        if (output.endsWith(" ")) {
            output = output.substring(0, output.length() - 1);
        }
        return output;
    }

    public String getFieldSource() {
        return this.fieldSource;
    }

    public String getFieldTarget() {
        return this.fieldTarget;
    }

    @Override
    public List<String> getSourceBases() {
        return this.sourceBases;
    }
}

