/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.Map;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.PreprocessChainContext;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorWithSourceBasesBase;

public class TrimStringValuePreprocessor
extends StructuredContentPreprocessorWithSourceBasesBase<Object> {
    protected static final String CFG_SOURCE_FIELD = "source_field";
    protected static final String CFG_TARGET_FIELD = "target_field";
    protected static final String CFG_MAX_SIZE = "max_size";
    protected String fieldSource;
    protected String fieldTarget;
    protected int maxSize;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        super.init(settings);
        this.fieldSource = XContentMapValues.nodeStringValue((Object)settings.get(CFG_SOURCE_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.fieldSource, CFG_SOURCE_FIELD);
        this.fieldTarget = XContentMapValues.nodeStringValue((Object)settings.get(CFG_TARGET_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.fieldTarget, CFG_TARGET_FIELD);
        this.maxSize = this.readMandatoryIntegerConfigValue(settings, CFG_MAX_SIZE);
    }

    @Override
    protected void processOneSourceValue(Map<String, Object> data, Object context, String base, PreprocessChainContext chainContext) {
        Object v = null;
        v = this.fieldSource.contains(".") ? XContentMapValues.extractValue((String)this.fieldSource, data) : data.get(this.fieldSource);
        if (v != null) {
            if (!(v instanceof String)) {
                String msg = "Value for field '" + TrimStringValuePreprocessor.getFullFieldName(base, this.fieldSource) + "' is not String, so can't be processed";
                this.addDataWarning(chainContext, msg);
                this.logger.debug(msg, new Object[0]);
            } else {
                String origValue = v.toString().trim();
                if (origValue.length() > this.maxSize) {
                    origValue = this.maxSize > 4 ? origValue.substring(0, this.maxSize - 3) + "..." : origValue.substring(0, this.maxSize);
                }
                this.putTargetValue(data, origValue);
            }
        }
    }

    protected void putTargetValue(Map<String, Object> data, String value) {
        StructureUtils.putValueIntoMapOfMaps(data, this.fieldTarget, value);
    }

    @Override
    protected Object createContext(Map<String, Object> data) {
        return null;
    }

    public String getFieldSource() {
        return this.fieldSource;
    }

    public String getFieldTarget() {
        return this.fieldTarget;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

