/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class ValueUtils {
    public static final String PATTERN_KEY_ORIGINAL_VALUE = "__original";
    protected static final SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXX");

    public static String trimToNull(String src) {
        if (src == null || src.length() == 0) {
            return null;
        }
        if ((src = src.trim()).length() == 0) {
            return null;
        }
        return src;
    }

    public static boolean isEmpty(String src) {
        return src == null || src.length() == 0 || src.trim().length() == 0;
    }

    public static boolean isEmpty(Object src) {
        if (src instanceof String) {
            return ValueUtils.isEmpty((String)src);
        }
        return src == null;
    }

    public static List<String> parseCsvString(String toParse) {
        if (toParse == null || toParse.length() == 0) {
            return null;
        }
        String[] t = toParse.split(",");
        if (t.length == 0) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : t) {
            if (s == null || (s = s.trim()).length() <= 0) continue;
            ret.add(s);
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret;
    }

    public static String createCsvString(Collection<String> in) {
        if (in == null) {
            return null;
        }
        if (in.isEmpty()) {
            return "";
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String s : in) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String processStringValuePatternReplacement(String patternValue, Map<String, Object> data, Object originalValue) {
        return ValueUtils.processStringValuePatternReplacement(patternValue, data, originalValue, '{', '}', null);
    }

    public static String processStringValuePatternReplacement(String patternValue, Map<String, Object> data, Object originalValue, IValueEncoder encoder) {
        return ValueUtils.processStringValuePatternReplacement(patternValue, data, originalValue, '{', '}', encoder);
    }

    public static String processStringValuePatternReplacement(String patternValue, Map<String, Object> data, Object originalValue, char startKeyChar, char endKeyChar, IValueEncoder encoder) {
        if (patternValue == null || patternValue.length() == 0) {
            return patternValue;
        }
        StringBuilder finalContent = new StringBuilder();
        boolean inBraces = false;
        StringBuilder bracesContent = null;
        for (int idx = 0; idx < patternValue.length(); ++idx) {
            char ch = patternValue.charAt(idx);
            if (!inBraces && ch == startKeyChar) {
                inBraces = true;
                bracesContent = new StringBuilder();
                continue;
            }
            if (inBraces && ch == endKeyChar) {
                inBraces = false;
                String key = bracesContent.toString();
                if (key.length() <= 0) continue;
                Object v = null;
                if (PATTERN_KEY_ORIGINAL_VALUE.equals(key)) {
                    v = originalValue;
                } else if (data != null) {
                    v = key.contains(".") ? XContentMapValues.extractValue((String)key, data) : data.get(key);
                }
                if (v == null) continue;
                if (encoder != null) {
                    finalContent.append(encoder.encode(v));
                    continue;
                }
                finalContent.append(v.toString());
                continue;
            }
            if (inBraces) {
                bracesContent.append(ch);
                continue;
            }
            finalContent.append(ch);
        }
        if (inBraces) {
            finalContent.append(startKeyChar).append((CharSequence)bracesContent);
        }
        return finalContent.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String formatISODateTime(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = ISO_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return ISO_DATE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> parseJSON(byte[] jsonData) throws IOException {
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(jsonData);
            Map map = parser.mapAndClose();
            return map;
        }
    }

    static {
        ISO_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static interface IValueEncoder {
        public String encode(Object var1);
    }
}

