/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.PreprocessChainContext;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorBase;

public abstract class StructuredContentPreprocessorWithSourceBasesBase<T>
extends StructuredContentPreprocessorBase {
    protected static final String CFG_source_bases = "source_bases";
    protected List<String> sourceBases;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        if (settings == null) {
            throw new SettingsException("'settings' section is not defined for preprocessor " + this.name);
        }
        this.sourceBases = (List)settings.get(CFG_source_bases);
    }

    @Override
    public Map<String, Object> preprocessData(Map<String, Object> data, PreprocessChainContext chainContext) {
        if (data == null) {
            return null;
        }
        if (this.sourceBases == null) {
            this.processOneSourceValue(data, null, null, chainContext);
        } else {
            T context = this.createContext();
            for (String base : this.sourceBases) {
                Object obj = XContentMapValues.extractValue((String)base, data);
                if (obj == null) continue;
                if (obj instanceof Map) {
                    this.processOneSourceValue((Map)obj, context, base, chainContext);
                    continue;
                }
                if (obj instanceof Collection) {
                    for (Object o : (Collection)obj) {
                        if (o instanceof Map) {
                            this.processOneSourceValue((Map)o, context, base, chainContext);
                            continue;
                        }
                        String msg = "Collection if field '" + base + "' contains value which is not Map, which can't be processed as source_base, so is skipped";
                        this.addDataWarning(chainContext, msg);
                        this.logger.debug(msg, new Object[0]);
                    }
                    continue;
                }
                String msg = "Field '" + base + "' contains invalid value which can't be processed as source_base, so is skipped";
                this.addDataWarning(chainContext, msg);
                this.logger.debug(msg, new Object[0]);
            }
        }
        return data;
    }

    protected abstract void processOneSourceValue(Map<String, Object> var1, T var2, String var3, PreprocessChainContext var4);

    protected abstract T createContext();

    protected static String getFullFieldName(String base, String field) {
        if (base != null) {
            return base + "." + field;
        }
        return field;
    }

    public List<String> getSourceBases() {
        return this.sourceBases;
    }
}

