/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.Date;
import java.util.Map;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.PreprocessChainContext;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorWithSourceBasesBase;
import org.jboss.elasticsearch.tools.content.ValueUtils;

public class LongToTimestampValuePreprocessor
extends StructuredContentPreprocessorWithSourceBasesBase<Object> {
    protected static final String CFG_SOURCE_FIELD = "source_field";
    protected static final String CFG_TARGET_FIELD = "target_field";
    protected String fieldSource;
    protected String fieldTarget;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        super.init(settings);
        this.fieldSource = XContentMapValues.nodeStringValue((Object)settings.get(CFG_SOURCE_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.fieldSource, CFG_SOURCE_FIELD);
        this.fieldTarget = XContentMapValues.nodeStringValue((Object)settings.get(CFG_TARGET_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.fieldTarget, CFG_TARGET_FIELD);
    }

    @Override
    protected void processOneSourceValue(Map<String, Object> data, Object context, String base, PreprocessChainContext chainContext) {
        Object v = null;
        v = this.fieldSource.contains(".") ? XContentMapValues.extractValue((String)this.fieldSource, data) : data.get(this.fieldSource);
        if (v != null) {
            if (v instanceof Integer) {
                this.putTargetValue(data, ValueUtils.formatISODateTime(new Date(((Integer)v).longValue())));
            } else if (v instanceof Long) {
                this.putTargetValue(data, ValueUtils.formatISODateTime(new Date((Long)v)));
            } else if (v instanceof String) {
                String vs = ValueUtils.trimToNull((String)v);
                if (vs != null) {
                    try {
                        this.putTargetValue(data, ValueUtils.formatISODateTime(new Date(new Long(vs))));
                    }
                    catch (NumberFormatException e) {
                        String warningMessage = "value '" + vs + "' for field '" + this.fieldSource + "' is not number, so can't be converted to timestamp";
                        this.addDataWarning(chainContext, warningMessage);
                        this.logger.debug(warningMessage, new Object[0]);
                    }
                }
            } else {
                String warningMessage = "value for field '" + this.fieldSource + "' is not Long but is " + v.getClass().getName() + ", so can't be processed";
                this.addDataWarning(chainContext, warningMessage);
                this.logger.debug(warningMessage, new Object[0]);
            }
        }
    }

    @Override
    protected Object createContext(Map<String, Object> data) {
        return null;
    }

    protected void putTargetValue(Map<String, Object> data, Object value) {
        StructureUtils.putValueIntoMapOfMaps(data, this.fieldTarget, value);
    }

    public String getFieldSource() {
        return this.fieldSource;
    }

    public String getFieldTarget() {
        return this.fieldTarget;
    }
}

