/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.PreprocessChainContext;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorBase;
import org.jboss.elasticsearch.tools.content.ValueUtils;

public class ValuesCollectingPreprocessor
extends StructuredContentPreprocessorBase {
    protected static final String CFG_SOURCE_FIELDS = "source_fields";
    protected static final String CFG_TARGET_FIELD = "target_field";
    protected static final String CFG_DEEP_COPY = "deep_copy";
    protected String fieldTarget;
    protected List<String> fieldsSource;
    protected boolean fieldDeepCopy;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        if (settings == null) {
            throw new SettingsException("'settings' section is not defined for preprocessor " + this.name);
        }
        this.fieldsSource = (List)settings.get(CFG_SOURCE_FIELDS);
        this.validateConfigurationObjectNotEmpty(this.fieldsSource, CFG_SOURCE_FIELDS);
        this.fieldTarget = XContentMapValues.nodeStringValue((Object)settings.get(CFG_TARGET_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.fieldTarget, CFG_TARGET_FIELD);
        String fieldDeepCopyStr = XContentMapValues.nodeStringValue((Object)settings.get(CFG_DEEP_COPY), (String)"false");
        this.fieldDeepCopy = fieldDeepCopyStr.compareTo("true") == 0;
    }

    @Override
    public Map<String, Object> preprocessData(Map<String, Object> data, PreprocessChainContext chainContext) {
        if (data == null) {
            return null;
        }
        HashSet<Object> vals = new HashSet<Object>();
        for (String sourceField : this.fieldsSource) {
            if (ValueUtils.isEmpty(sourceField)) continue;
            Object v = XContentMapValues.extractValue((String)sourceField, data);
            this.collectValue(vals, v);
        }
        if (vals != null && !vals.isEmpty()) {
            StructureUtils.putValueIntoMapOfMaps(data, this.fieldTarget, new ArrayList(vals));
        } else {
            StructureUtils.putValueIntoMapOfMaps(data, this.fieldTarget, null);
        }
        return data;
    }

    private void collectValue(Set<Object> values, Object value) {
        if (value != null) {
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    if (this.fieldDeepCopy) {
                        this.collectValue(values, StructureUtils.getADeepStructureCopy(o));
                        continue;
                    }
                    this.collectValue(values, o);
                }
            } else if (this.fieldDeepCopy) {
                values.add(StructureUtils.getADeepStructureCopy(value));
            } else {
                values.add(value);
            }
        }
    }

    public String getFieldTarget() {
        return this.fieldTarget;
    }

    public List<String> getFieldsSource() {
        return this.fieldsSource;
    }
}

