/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.component;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.EntityModeToTuplizerMapping;
import org.hibernate.tuple.component.ComponentTuplizer;
import org.hibernate.tuple.component.Dom4jComponentTuplizer;
import org.hibernate.tuple.component.DynamicMapComponentTuplizer;
import org.hibernate.tuple.component.PojoComponentTuplizer;
import org.hibernate.util.ReflectHelper;

class ComponentEntityModeToTuplizerMapping
extends EntityModeToTuplizerMapping
implements Serializable {
    private static final Class[] COMPONENT_TUP_CTOR_SIG = new Class[]{Component.class};

    public ComponentEntityModeToTuplizerMapping(Component component) {
        PersistentClass owner = component.getOwner();
        HashMap userSuppliedTuplizerImpls = new HashMap();
        if (component.getTuplizerMap() != null) {
            userSuppliedTuplizerImpls.putAll(component.getTuplizerMap());
        }
        ComponentTuplizer dynamicMapTuplizer = null;
        String tuplizerImpl = (String)userSuppliedTuplizerImpls.remove(EntityMode.MAP);
        dynamicMapTuplizer = tuplizerImpl == null ? new DynamicMapComponentTuplizer(component) : this.buildComponentTuplizer(tuplizerImpl, component);
        tuplizerImpl = (String)userSuppliedTuplizerImpls.remove(EntityMode.POJO);
        ComponentTuplizer pojoTuplizer = null;
        pojoTuplizer = owner.hasPojoRepresentation() && component.hasPojoRepresentation() ? (tuplizerImpl == null ? new PojoComponentTuplizer(component) : this.buildComponentTuplizer(tuplizerImpl, component)) : dynamicMapTuplizer;
        ComponentTuplizer dom4jTuplizer = null;
        tuplizerImpl = (String)userSuppliedTuplizerImpls.remove(EntityMode.DOM4J);
        dom4jTuplizer = owner.hasDom4jRepresentation() ? (tuplizerImpl == null ? new Dom4jComponentTuplizer(component) : this.buildComponentTuplizer(tuplizerImpl, component)) : null;
        if (pojoTuplizer != null) {
            this.addTuplizer(EntityMode.POJO, pojoTuplizer);
        }
        if (dynamicMapTuplizer != null) {
            this.addTuplizer(EntityMode.MAP, dynamicMapTuplizer);
        }
        if (dom4jTuplizer != null) {
            this.addTuplizer(EntityMode.DOM4J, dom4jTuplizer);
        }
        if (!userSuppliedTuplizerImpls.isEmpty()) {
            Iterator itr = userSuppliedTuplizerImpls.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                EntityMode entityMode = (EntityMode)entry.getKey();
                ComponentTuplizer tuplizer = this.buildComponentTuplizer((String)entry.getValue(), component);
                this.addTuplizer(entityMode, tuplizer);
            }
        }
    }

    private ComponentTuplizer buildComponentTuplizer(String tuplizerImpl, Component component) {
        try {
            Class implClass = ReflectHelper.classForName(tuplizerImpl);
            return (ComponentTuplizer)implClass.getConstructor(COMPONENT_TUP_CTOR_SIG).newInstance(component);
        }
        catch (Throwable t) {
            throw new HibernateException("Could not build tuplizer [" + tuplizerImpl + "]", t);
        }
    }
}

