/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.ASTFactory;
import antlr.collections.AST;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.hql.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.QueryNode;
import org.hibernate.hql.ast.tree.RestrictableStatement;
import org.hibernate.hql.ast.tree.SqlFragment;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.util.StringHelper;

public class SyntheticAndFactory
implements HqlSqlTokenTypes {
    private static final Log log = LogFactory.getLog(SyntheticAndFactory.class);
    private ASTFactory astFactory;
    private AST thetaJoins;
    private AST filters;

    public SyntheticAndFactory(ASTFactory astFactory) {
        this.astFactory = astFactory;
    }

    public void addWhereFragment(JoinFragment joinFragment, String whereFragment, QueryNode query, FromElement fromElement) {
        if (whereFragment == null) {
            return;
        }
        if (StringHelper.isEmpty(whereFragment = whereFragment.trim())) {
            return;
        }
        if (!fromElement.useWhereFragment() && !joinFragment.hasThetaJoins()) {
            return;
        }
        if (whereFragment.startsWith("and")) {
            whereFragment = whereFragment.substring(4);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using WHERE fragment [" + whereFragment + "]"));
        }
        SqlFragment fragment = (SqlFragment)ASTUtil.create(this.astFactory, 136, whereFragment);
        fragment.setJoinFragment(joinFragment);
        fragment.setFromElement(fromElement);
        if (fragment.getFromElement().isFilter() || fragment.hasFilterCondition()) {
            if (this.filters == null) {
                AST where = query.getWhereClause();
                this.filters = this.astFactory.create(140, "{filter conditions}");
                ASTUtil.insertChild(where, this.filters);
            }
            this.filters.addChild((AST)fragment);
        } else {
            if (this.thetaJoins == null) {
                AST where = query.getWhereClause();
                this.thetaJoins = this.astFactory.create(139, "{theta joins}");
                if (this.filters == null) {
                    ASTUtil.insertChild(where, this.thetaJoins);
                } else {
                    ASTUtil.insertSibling(this.thetaJoins, this.filters);
                }
            }
            this.thetaJoins.addChild((AST)fragment);
        }
    }

    public void addDiscriminatorWhereFragment(RestrictableStatement statement, Queryable persister, Map enabledFilters, String alias) {
        String whereFragment = persister.filterFragment(alias, enabledFilters).trim();
        if ("".equals(whereFragment)) {
            return;
        }
        if (whereFragment.startsWith("and")) {
            whereFragment = whereFragment.substring(4);
        }
        whereFragment = StringHelper.replace(whereFragment, persister.generateFilterConditionAlias(alias) + ".", "");
        AST discrimNode = this.astFactory.create(136, whereFragment);
        if (statement.getWhereClause().getNumberOfChildren() == 0) {
            statement.getWhereClause().setFirstChild(discrimNode);
        } else {
            AST and = this.astFactory.create(6, "{and}");
            AST currentFirstChild = statement.getWhereClause().getFirstChild();
            and.setFirstChild(discrimNode);
            and.addChild(currentFirstChild);
            statement.getWhereClause().setFirstChild(and);
        }
    }
}

